/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ControlConfig;
import cn.felord.enumeration.AttendanceType;
import cn.felord.enumeration.DateRangeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AttendanceConfig
implements ControlConfig {
    private final Wrapper attendance;

    @JsonCreator
    AttendanceConfig(@JsonProperty(value="attendance") Wrapper attendance) {
        this.attendance = attendance;
    }

    public static AttendanceConfig from(AttendanceType attendanceType, DateRangeType dateRangeType) {
        return new AttendanceConfig(new Wrapper(attendanceType, new AttendanceDateRange(dateRangeType)));
    }

    public String toString() {
        return "AttendanceConfig(attendance=" + this.getAttendance() + ")";
    }

    public Wrapper getAttendance() {
        return this.attendance;
    }

    public static class AttendanceDateRange {
        private final DateRangeType type;

        @JsonCreator
        AttendanceDateRange(@JsonProperty(value="type") DateRangeType type) {
            this.type = type;
        }

        public String toString() {
            return "AttendanceConfig.AttendanceDateRange(type=" + (Object)((Object)this.getType()) + ")";
        }

        public DateRangeType getType() {
            return this.type;
        }
    }

    public static class Wrapper {
        private final AttendanceType type;
        private final AttendanceDateRange dateRange;

        @JsonCreator
        Wrapper(@JsonProperty(value="type") AttendanceType type, @JsonProperty(value="dateRange") AttendanceDateRange dateRange) {
            this.type = type;
            this.dateRange = dateRange;
        }

        public String toString() {
            return "AttendanceConfig.Wrapper(type=" + (Object)((Object)this.getType()) + ", dateRange=" + this.getDateRange() + ")";
        }

        public AttendanceType getType() {
            return this.type;
        }

        public AttendanceDateRange getDateRange() {
            return this.dateRange;
        }
    }
}

