/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.DateRangeWrapper;
import cn.felord.enumeration.AttendanceType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AttendanceValue
implements ContentDataValue {
    private final Wrapper attendance;

    @JsonCreator
    AttendanceValue(@JsonProperty(value="attendance") Wrapper attendance) {
        this.attendance = attendance;
    }

    public AttendanceValue(AttendanceType type, DateRangeWrapper dateRange) {
        this.attendance = new Wrapper(type, dateRange);
    }

    public static AttendanceValue leave(DateRangeWrapper dateRange) {
        return new AttendanceValue(AttendanceType.LEAVE, dateRange);
    }

    public static AttendanceValue trip(DateRangeWrapper dateRange) {
        return new AttendanceValue(AttendanceType.BUSINESS_TRIP, dateRange);
    }

    public static AttendanceValue goingOut(DateRangeWrapper dateRange) {
        return new AttendanceValue(AttendanceType.GOING_OUT, dateRange);
    }

    public static AttendanceValue overtime(DateRangeWrapper dateRange) {
        return new AttendanceValue(AttendanceType.OVERTIME_WORK, dateRange);
    }

    public String toString() {
        return "AttendanceValue(attendance=" + this.getAttendance() + ")";
    }

    public Wrapper getAttendance() {
        return this.attendance;
    }

    public static class Wrapper {
        private final AttendanceType type;
        private final DateRangeWrapper dateRange;

        @JsonCreator
        Wrapper(@JsonProperty(value="type") AttendanceType type, @JsonProperty(value="date_range") DateRangeWrapper dateRange) {
            this.type = type;
            this.dateRange = dateRange;
        }

        public String toString() {
            return "AttendanceValue.Wrapper(type=" + (Object)((Object)this.getType()) + ", dateRange=" + this.getDateRange() + ")";
        }

        public AttendanceType getType() {
            return this.type;
        }

        public DateRangeWrapper getDateRange() {
            return this.dateRange;
        }
    }
}

