/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.BankInfo;
import cn.felord.domain.approval.ContentDataValue;
import cn.felord.enumeration.ApvlBankAccountType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;

public class BankAccountValue
implements ContentDataValue {
    private final BankAccount bankAccount;

    @JsonCreator
    BankAccountValue(@JsonProperty(value="bank_account") BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    protected static BankAccountValue from(@NonNull ApvlBankAccountType accountType, @NonNull String accountName, @NonNull String accountNumber, @NonNull BankInfo bank, String remark) {
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName is marked non-null but is null");
        }
        if (accountNumber == null) {
            throw new NullPointerException("accountNumber is marked non-null but is null");
        }
        if (bank == null) {
            throw new NullPointerException("bank is marked non-null but is null");
        }
        return new BankAccountValue(new BankAccount(accountType, accountName, accountNumber, bank, remark));
    }

    protected static BankAccountValue from(@NonNull ApvlBankAccountType accountType, @NonNull String accountName, @NonNull String accountNumber, @NonNull BankInfo bank) {
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName is marked non-null but is null");
        }
        if (accountNumber == null) {
            throw new NullPointerException("accountNumber is marked non-null but is null");
        }
        if (bank == null) {
            throw new NullPointerException("bank is marked non-null but is null");
        }
        return new BankAccountValue(new BankAccount(accountType, accountName, accountNumber, bank));
    }

    public String toString() {
        return "BankAccountValue(bankAccount=" + this.getBankAccount() + ")";
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public static class BankAccount {
        private final ApvlBankAccountType accountType;
        private final String accountName;
        private final String accountNumber;
        private final BankInfo bank;
        private final String remark;

        BankAccount(ApvlBankAccountType accountType, String accountName, String accountNumber, BankInfo bank) {
            this(accountType, accountName, accountNumber, bank, null);
        }

        @JsonCreator
        BankAccount(@JsonProperty(value="account_type") ApvlBankAccountType accountType, @JsonProperty(value="account_name") String accountName, @JsonProperty(value="account_number") String accountNumber, @JsonProperty(value="bank") BankInfo bank, @JsonProperty(value="remark") String remark) {
            this.accountType = accountType;
            this.accountName = accountName;
            this.accountNumber = accountNumber;
            this.bank = bank;
            this.remark = remark;
        }

        public String toString() {
            return "BankAccountValue.BankAccount(accountType=" + (Object)((Object)this.getAccountType()) + ", accountName=" + this.getAccountName() + ", accountNumber=" + this.getAccountNumber() + ", bank=" + this.getBank() + ", remark=" + this.getRemark() + ")";
        }

        public ApvlBankAccountType getAccountType() {
            return this.accountType;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public BankInfo getBank() {
            return this.bank;
        }

        public String getRemark() {
            return this.remark;
        }
    }
}

