/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.enumeration.ContactCtrlMode;
import cn.felord.utils.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ContactValue
implements ContentDataValue {
    @JsonIgnore
    private final ContactCtrlMode contactCtrlMode;
    private final List<MemberInfo> members;
    private final Set<ApprovalDeptInfo> departments;

    @JsonCreator
    ContactValue(@JsonProperty(value="members") List<MemberInfo> members, @JsonProperty(value="departments") Set<ApprovalDeptInfo> departments) {
        this.contactCtrlMode = CollectionUtils.isEmpty(members) ? ContactCtrlMode.DEPARTMENT : ContactCtrlMode.USER;
        this.members = members;
        this.departments = departments;
    }

    public static ContactValue user(List<MemberInfo> members) {
        return new ContactValue(members, Collections.emptySet());
    }

    public static ContactValue users(List<String> userIds) {
        List<MemberInfo> members = userIds.stream().map(userId -> new MemberInfo((String)userId, "")).collect(Collectors.toList());
        return new ContactValue(members, Collections.emptySet());
    }

    public static ContactValue dept(Set<ApprovalDeptInfo> departments) {
        return new ContactValue(Collections.emptyList(), departments);
    }

    public static ContactValue depts(List<Long> partyIds) {
        Set<ApprovalDeptInfo> departments = partyIds.stream().map(partyId -> new ApprovalDeptInfo((Long)partyId, "")).collect(Collectors.toSet());
        return new ContactValue(Collections.emptyList(), departments);
    }

    public String toString() {
        return "ContactValue(contactCtrlMode=" + (Object)((Object)this.getContactCtrlMode()) + ", members=" + this.getMembers() + ", departments=" + this.getDepartments() + ")";
    }

    public ContactCtrlMode getContactCtrlMode() {
        return this.contactCtrlMode;
    }

    public List<MemberInfo> getMembers() {
        return this.members;
    }

    public Set<ApprovalDeptInfo> getDepartments() {
        return this.departments;
    }

    public static class ApprovalDeptInfo {
        private final Long openapiId;
        private final String name;

        @JsonCreator
        public ApprovalDeptInfo(@JsonProperty(value="openapi_id") Long openapiId, @JsonProperty(value="name") String name) {
            this.openapiId = openapiId;
            this.name = name;
        }

        public String toString() {
            return "ContactValue.ApprovalDeptInfo(openapiId=" + this.getOpenapiId() + ", name=" + this.getName() + ")";
        }

        public Long getOpenapiId() {
            return this.openapiId;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class MemberInfo {
        private final String userid;
        private final String name;

        @JsonCreator
        public MemberInfo(@JsonProperty(value="userid") String userid, @JsonProperty(value="name") String name) {
            this.userid = userid;
            this.name = name;
        }

        public String toString() {
            return "ContactValue.MemberInfo(userid=" + this.getUserid() + ", name=" + this.getName() + ")";
        }

        public String getUserid() {
            return this.userid;
        }

        public String getName() {
            return this.name;
        }
    }
}

