/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.DateRangeWrapper;
import cn.felord.enumeration.DateRangeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;

public class DateRangeValue
implements ContentDataValue {
    private final DateRangeWrapper dateRange;

    public static DateRangeValue halfDay(Instant newBegin, Instant newEnd) {
        return new DateRangeValue(DateRangeType.HALF_DAY, newBegin, newEnd);
    }

    public static DateRangeValue hour(Instant newBegin, Instant newEnd) {
        return new DateRangeValue(DateRangeType.HOUR, newBegin, newEnd);
    }

    @JsonCreator
    DateRangeValue(@JsonProperty(value="date_range") DateRangeWrapper dateRange) {
        this.dateRange = dateRange;
    }

    DateRangeValue(DateRangeType type, Instant newBegin, Instant newEnd) {
        this.dateRange = new DateRangeWrapper(type, newBegin, newEnd, Duration.between(newBegin, newEnd), null, null);
    }

    public String toString() {
        return "DateRangeValue(dateRange=" + this.getDateRange() + ")";
    }

    public DateRangeWrapper getDateRange() {
        return this.dateRange;
    }
}

