/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.TimezoneInfo;
import cn.felord.enumeration.DateRangeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.Instant;

public class DateRangeWrapper {
    private final DateRangeType type;
    private final Instant newBegin;
    private final Instant newEnd;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER, pattern="SECONDS")
    private final Duration newDuration;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER, pattern="SECONDS")
    private final Duration perdayDuration;
    private final TimezoneInfo timezoneInfo;

    @JsonCreator
    DateRangeWrapper(@JsonProperty(value="type") DateRangeType type, @JsonProperty(value="new_begin") Instant newBegin, @JsonProperty(value="new_end") Instant newEnd, @JsonProperty(value="new_duration") Duration newDuration, @JsonProperty(value="perday_duration") Duration perdayDuration, @JsonProperty(value="timezone_info") TimezoneInfo timezoneInfo) {
        this.type = type;
        this.newBegin = newBegin;
        this.newEnd = newEnd;
        this.newDuration = newDuration;
        this.perdayDuration = perdayDuration;
        this.timezoneInfo = timezoneInfo;
    }

    public DateRangeWrapper(DateRangeType type, Instant newBegin, Instant newEnd, Duration newDuration) {
        this(type, newBegin, newEnd, newDuration, null, null);
    }

    public static DateRangeWrapper halfDay(Instant newBegin, Instant newEnd) {
        return new DateRangeWrapper(DateRangeType.HALF_DAY, newBegin, newEnd, Duration.between(newBegin, newEnd));
    }

    public static DateRangeWrapper hour(Instant newBegin, Instant newEnd) {
        return new DateRangeWrapper(DateRangeType.HOUR, newBegin, newEnd, Duration.between(newBegin, newEnd));
    }

    public String toString() {
        return "DateRangeWrapper(type=" + (Object)((Object)this.getType()) + ", newBegin=" + this.getNewBegin() + ", newEnd=" + this.getNewEnd() + ", newDuration=" + this.getNewDuration() + ", perdayDuration=" + this.getPerdayDuration() + ", timezoneInfo=" + this.getTimezoneInfo() + ")";
    }

    public DateRangeType getType() {
        return this.type;
    }

    public Instant getNewBegin() {
        return this.newBegin;
    }

    public Instant getNewEnd() {
        return this.newEnd;
    }

    public Duration getNewDuration() {
        return this.newDuration;
    }

    public Duration getPerdayDuration() {
        return this.perdayDuration;
    }

    public TimezoneInfo getTimezoneInfo() {
        return this.timezoneInfo;
    }
}

