/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.TimezoneInfo;
import cn.felord.enumeration.DateCtrlType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

public class DateValue
implements ContentDataValue {
    private final Wrapper date;

    @JsonCreator
    DateValue(@JsonProperty(value="date") Wrapper date) {
        this.date = date;
    }

    public static DateValue date(Instant sTimestamp) {
        return new DateValue(new Wrapper(DateCtrlType.DAY, sTimestamp, null));
    }

    public static DateValue dateTime(Instant sTimestamp) {
        return new DateValue(new Wrapper(DateCtrlType.HOUR, sTimestamp, null));
    }

    public String toString() {
        return "DateValue(date=" + this.getDate() + ")";
    }

    public Wrapper getDate() {
        return this.date;
    }

    public static class Wrapper {
        private final DateCtrlType type;
        @JsonProperty(value="s_timestamp")
        private final Instant sTimestamp;
        private final TimezoneInfo timezoneInfo;

        @JsonCreator
        Wrapper(@JsonProperty(value="type") DateCtrlType type, @JsonProperty(value="s_timestamp") Instant sTimestamp, @JsonProperty(value="timezone_info") TimezoneInfo timezoneInfo) {
            this.type = type;
            this.sTimestamp = sTimestamp;
            this.timezoneInfo = timezoneInfo;
        }

        public String toString() {
            return "DateValue.Wrapper(type=" + (Object)((Object)this.getType()) + ", sTimestamp=" + this.getSTimestamp() + ", timezoneInfo=" + this.getTimezoneInfo() + ")";
        }

        public DateCtrlType getType() {
            return this.type;
        }

        public Instant getSTimestamp() {
            return this.sTimestamp;
        }

        public TimezoneInfo getTimezoneInfo() {
            return this.timezoneInfo;
        }
    }
}

