/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

public class LocationValue
implements ContentDataValue {
    private final Wrapper location;

    @JsonCreator
    LocationValue(@JsonProperty(value="location") Wrapper location) {
        this.location = location;
    }

    public static LocationValue from(String latitude, String longitude, String title, String address, Instant time) {
        return new LocationValue(new Wrapper(latitude, longitude, title, address, time));
    }

    public String toString() {
        return "LocationValue(location=" + this.getLocation() + ")";
    }

    public Wrapper getLocation() {
        return this.location;
    }

    public static class Wrapper {
        private final String latitude;
        private final String longitude;
        private final String title;
        private final String address;
        private final Instant time;

        @JsonCreator
        Wrapper(@JsonProperty(value="latitude") String latitude, @JsonProperty(value="longitude") String longitude, @JsonProperty(value="title") String title, @JsonProperty(value="address") String address, @JsonProperty(value="time") Instant time) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.title = title;
            this.address = address;
            this.time = time;
        }

        public String toString() {
            return "LocationValue.Wrapper(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", time=" + this.getTime() + ")";
        }

        public String getLatitude() {
            return this.latitude;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public String getTitle() {
            return this.title;
        }

        public String getAddress() {
            return this.address;
        }

        public Instant getTime() {
            return this.time;
        }
    }
}

