/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class MoneyValue
implements ContentDataValue {
    private final String newMoney;

    @JsonCreator
    MoneyValue(@JsonProperty(value="new_money") String newMoney) {
        this.newMoney = newMoney;
    }

    public static MoneyValue from(long newMoney) {
        String money = BigDecimal.valueOf(newMoney).setScale(2, RoundingMode.HALF_UP).toPlainString();
        return new MoneyValue(money);
    }

    public static MoneyValue from(int newMoney) {
        String money = BigDecimal.valueOf(newMoney).setScale(2, RoundingMode.HALF_UP).toPlainString();
        return new MoneyValue(money);
    }

    public static MoneyValue from(double newMoney) {
        String money = BigDecimal.valueOf(newMoney).setScale(2, RoundingMode.HALF_UP).toPlainString();
        return new MoneyValue(money);
    }

    public static MoneyValue from(float newMoney) {
        String money = BigDecimal.valueOf(newMoney).setScale(2, RoundingMode.HALF_UP).toPlainString();
        return new MoneyValue(money);
    }

    public static MoneyValue from(BigDecimal newMoney) {
        String money = Optional.ofNullable(newMoney).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP).toPlainString();
        return new MoneyValue(money);
    }

    public String toString() {
        return "MoneyValue(newMoney=" + this.getNewMoney() + ")";
    }

    public String getNewMoney() {
        return this.newMoney;
    }
}

