/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.enumeration.ApvRel;
import cn.felord.enumeration.ProcessNodeType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class ProcessNode {
    private final ProcessNodeType type;
    private final ApvRel apvRel;
    private final List<String> userid;

    @JsonCreator
    ProcessNode(@JsonProperty(value="type") ProcessNodeType type, @JsonProperty(value="apv_rel") ApvRel apvRel, @JsonProperty(value="userid") List<String> userid) {
        this.type = type;
        this.apvRel = apvRel;
        this.userid = userid;
    }

    public static ProcessNode create(ProcessNodeType type, ApvRel apvRel, List<String> userid) {
        return new ProcessNode(type, apvRel, userid);
    }

    public static ProcessNode assignees(ApvRel apvRel, List<String> userid) {
        return ProcessNode.create(ProcessNodeType.ASSIGNEE, apvRel, userid);
    }

    public static ProcessNode cc(ApvRel apvRel, List<String> userid) {
        return ProcessNode.create(ProcessNodeType.CC, apvRel, userid);
    }

    public static ProcessNode processor(List<String> userid) {
        return ProcessNode.create(ProcessNodeType.PROCESSOR, null, userid);
    }

    public String toString() {
        return "ProcessNode(type=" + this.getType() + ", apvRel=" + this.getApvRel() + ", userid=" + this.getUserid() + ")";
    }

    public ProcessNodeType getType() {
        return this.type;
    }

    public ApvRel getApvRel() {
        return this.apvRel;
    }

    public List<String> getUserid() {
        return this.userid;
    }
}

