/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ApprovalTitle;
import cn.felord.domain.approval.ContentDataValue;
import cn.felord.enumeration.SpStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class RelatedApprovalValue
implements ContentDataValue {
    private final List<Wrapper> relatedApproval;

    @JsonCreator
    RelatedApprovalValue(@JsonProperty(value="related_approval") List<Wrapper> relatedApproval) {
        this.relatedApproval = relatedApproval;
    }

    public static RelatedApprovalValue from(List<String> spNo) {
        List<Wrapper> wrappers = spNo.stream().map(Wrapper::new).collect(Collectors.toList());
        return new RelatedApprovalValue(wrappers);
    }

    public String toString() {
        return "RelatedApprovalValue(relatedApproval=" + this.getRelatedApproval() + ")";
    }

    public List<Wrapper> getRelatedApproval() {
        return this.relatedApproval;
    }

    public static class Wrapper {
        private final String spNo;
        private final Instant createTime;
        private final String name;
        private final SpStatus spStatus;
        private final List<ApprovalTitle> templateNames;

        Wrapper(String spNo) {
            this(spNo, null, null, null, null);
        }

        @JsonCreator
        Wrapper(@JsonProperty(value="sp_no") String spNo, @JsonProperty(value="create_time") Instant createTime, @JsonProperty(value="name") String name, @JsonProperty(value="sp_status") SpStatus spStatus, @JsonProperty(value="template_names") List<ApprovalTitle> templateNames) {
            this.spNo = spNo;
            this.createTime = createTime;
            this.name = name;
            this.spStatus = spStatus;
            this.templateNames = templateNames;
        }

        public String toString() {
            return "RelatedApprovalValue.Wrapper(spNo=" + this.getSpNo() + ", createTime=" + this.getCreateTime() + ", name=" + this.getName() + ", spStatus=" + this.getSpStatus() + ", templateNames=" + this.getTemplateNames() + ")";
        }

        public String getSpNo() {
            return this.spNo;
        }

        public Instant getCreateTime() {
            return this.createTime;
        }

        public String getName() {
            return this.name;
        }

        public SpStatus getSpStatus() {
            return this.spStatus;
        }

        public List<ApprovalTitle> getTemplateNames() {
            return this.templateNames;
        }
    }
}

