/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ControlConfig;
import cn.felord.domain.approval.CtrlOption;
import cn.felord.domain.approval.ExternalOption;
import cn.felord.domain.approval.OpRelation;
import cn.felord.domain.approval.SelectorKey;
import cn.felord.domain.approval.SelectorValue;
import cn.felord.enumeration.SelectType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class SelectorConfig
implements ControlConfig {
    private final Wrapper selector;

    @JsonCreator
    SelectorConfig(@JsonProperty(value="selector") Wrapper selector) {
        this.selector = selector;
    }

    public static SelectorConfig single(List<CtrlOption> options) {
        return SelectorConfig.single(options, null);
    }

    public static SelectorConfig single(List<CtrlOption> options, List<OpRelation> opRelations) {
        Wrapper wrapper = new Wrapper(SelectType.SINGLE, options, opRelations, null);
        return new SelectorConfig(wrapper);
    }

    public static SelectorConfig single(String externalUrl) {
        Wrapper wrapper = new Wrapper(SelectType.SINGLE, null, null, new ExternalOption(true, externalUrl));
        return new SelectorConfig(wrapper);
    }

    public static SelectorConfig multiple(List<CtrlOption> options) {
        return SelectorConfig.multiple(options, null);
    }

    public static SelectorConfig multiple(List<CtrlOption> options, List<OpRelation> opRelations) {
        Wrapper wrapper = new Wrapper(SelectType.MULTI, options, opRelations, null);
        return new SelectorConfig(wrapper);
    }

    public static SelectorConfig multiple(String externalUrl) {
        Wrapper wrapper = new Wrapper(SelectType.MULTI, null, null, new ExternalOption(true, externalUrl));
        return new SelectorConfig(wrapper);
    }

    public SelectorValue fromKey(List<String> keys) {
        List<SelectorKey> selectorKeys = this.selector.options.stream().map(CtrlOption::getKey).filter(keys::contains).map(SelectorKey::new).collect(Collectors.toList());
        SelectorValue.Wrapper wrapper = new SelectorValue.Wrapper(this.selector.type, selectorKeys);
        return new SelectorValue(wrapper);
    }

    public String toString() {
        return "SelectorConfig(selector=" + this.getSelector() + ")";
    }

    public Wrapper getSelector() {
        return this.selector;
    }

    public static class Wrapper {
        private final SelectType type;
        private final List<CtrlOption> options;
        private final List<OpRelation> opRelations;
        private final ExternalOption externalOption;

        @JsonCreator
        Wrapper(@JsonProperty(value="type") SelectType type, @JsonProperty(value="options") List<CtrlOption> options, @JsonProperty(value="op_relations") List<OpRelation> opRelations, @JsonProperty(value="external_option") ExternalOption externalOption) {
            this.type = type;
            this.options = options;
            this.opRelations = opRelations;
            this.externalOption = externalOption;
        }

        public String toString() {
            return "SelectorConfig.Wrapper(type=" + (Object)((Object)this.getType()) + ", options=" + this.getOptions() + ", opRelations=" + this.getOpRelations() + ", externalOption=" + this.getExternalOption() + ")";
        }

        public SelectType getType() {
            return this.type;
        }

        public List<CtrlOption> getOptions() {
            return this.options;
        }

        public List<OpRelation> getOpRelations() {
            return this.opRelations;
        }

        public ExternalOption getExternalOption() {
            return this.externalOption;
        }
    }
}

