/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.SelectorKey;
import cn.felord.enumeration.SelectType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SelectorValue
implements ContentDataValue {
    private final Wrapper selector;

    @JsonCreator
    SelectorValue(@JsonProperty(value="selector") Wrapper selector) {
        this.selector = selector;
    }

    public static SelectorValue single(String optionKey) {
        Wrapper wrapper = new Wrapper(SelectType.SINGLE, Collections.singletonList(new SelectorKey(optionKey)));
        return new SelectorValue(wrapper);
    }

    public static SelectorValue multiple(List<String> optionKeys) {
        Wrapper wrapper = new Wrapper(SelectType.MULTI, optionKeys.stream().map(SelectorKey::new).collect(Collectors.toList()));
        return new SelectorValue(wrapper);
    }

    public String toString() {
        return "SelectorValue(selector=" + this.getSelector() + ")";
    }

    public Wrapper getSelector() {
        return this.selector;
    }

    public static class Wrapper {
        private final SelectType type;
        private final List<SelectorKey> options;

        @JsonCreator
        Wrapper(@JsonProperty(value="type") SelectType type, @JsonProperty(value="options") List<SelectorKey> options) {
            this.type = type;
            this.options = options;
        }

        public String toString() {
            return "SelectorValue.Wrapper(type=" + (Object)((Object)this.getType()) + ", options=" + this.getOptions() + ")";
        }

        public SelectType getType() {
            return this.type;
        }

        public List<SelectorKey> getOptions() {
            return this.options;
        }
    }
}

