/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.LinkTipContent;
import cn.felord.domain.approval.LinkTipSubText;
import cn.felord.domain.approval.TextTipContent;
import cn.felord.domain.approval.TextTipSubText;
import cn.felord.enumeration.TipsCtrlType;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.NonNull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TextTipSubText.class, name="1"), @JsonSubTypes.Type(value=LinkTipSubText.class, name="2")})
public abstract class TipSubText<CONTENT> {
    private final TipsCtrlType type;
    private final CONTENT content;

    TipSubText(TipsCtrlType type, CONTENT content) {
        this.type = type;
        this.content = content;
    }

    public static TipSubText<TextTipContent> text(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return new TextTipSubText(TipsCtrlType.TEXT, new TextTipContent(content));
    }

    public static TipSubText<LinkTipContent> link(@NonNull String title, @NonNull String url) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new LinkTipSubText(TipsCtrlType.LINK, new LinkTipContent(title, url));
    }

    public String toString() {
        return "TipSubText(type=" + (Object)((Object)this.getType()) + ", content=" + this.getContent() + ")";
    }

    public TipsCtrlType getType() {
        return this.type;
    }

    public CONTENT getContent() {
        return this.content;
    }
}

