/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ApprovalTitle;
import cn.felord.domain.approval.AttendanceConfig;
import cn.felord.domain.approval.ContactConfig;
import cn.felord.domain.approval.ControlConfig;
import cn.felord.domain.approval.CtrlProperty;
import cn.felord.domain.approval.DateConfig;
import cn.felord.domain.approval.DateRangeConfig;
import cn.felord.domain.approval.EmptyConfig;
import cn.felord.domain.approval.FileConfig;
import cn.felord.domain.approval.FormulaConfig;
import cn.felord.domain.approval.LocationConfig;
import cn.felord.domain.approval.RelatedApprovalConfig;
import cn.felord.domain.approval.SelectorConfig;
import cn.felord.domain.approval.TableConfig;
import cn.felord.domain.approval.TipsConfig;
import cn.felord.domain.approval.TmpControl;
import cn.felord.domain.approval.VacationConfig;
import cn.felord.enumeration.ApprovalCtrlType;
import cn.felord.enumeration.BoolEnum;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class TmpControlBuilder<C extends ControlConfig> {
    private static final Random RANDOM = new SecureRandom();
    private final ApprovalCtrlType control;
    private final List<ApprovalTitle> title;
    private List<ApprovalTitle> placeholder;
    private BoolEnum require;
    private BoolEnum unPrint;

    TmpControlBuilder(ApprovalCtrlType control, String title) {
        this.control = control;
        this.title = Collections.singletonList(ApprovalTitle.zhCN(title));
    }

    public TmpControlBuilder<C> placeholder(String placeholder) {
        this.placeholder = Collections.singletonList(ApprovalTitle.zhCN(placeholder));
        return this;
    }

    public TmpControlBuilder<C> require(BoolEnum require) {
        this.require = require;
        return this;
    }

    public TmpControlBuilder<C> unPrint(BoolEnum unPrint) {
        this.unPrint = unPrint;
        return this;
    }

    public static TmpControlBuilder<EmptyConfig> text(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.TEXT, title);
    }

    public static TmpControlBuilder<EmptyConfig> textarea(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.TEXTAREA, title);
    }

    public static TmpControlBuilder<EmptyConfig> number(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.NUMBER, title);
    }

    public static TmpControlBuilder<EmptyConfig> money(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.MONEY, title);
    }

    public static TmpControlBuilder<DateConfig> date(String title) {
        return new TmpControlBuilder<DateConfig>(ApprovalCtrlType.DATE, title);
    }

    public static TmpControlBuilder<SelectorConfig> selector(String title) {
        return new TmpControlBuilder<SelectorConfig>(ApprovalCtrlType.SELECTOR, title);
    }

    public static TmpControlBuilder<ContactConfig> contact(String title) {
        return new TmpControlBuilder<ContactConfig>(ApprovalCtrlType.CONTACT, title);
    }

    public static TmpControlBuilder<TipsConfig> tips(String title) {
        return new TmpControlBuilder<TipsConfig>(ApprovalCtrlType.TIPS, title);
    }

    public static TmpControlBuilder<FileConfig> file(String title) {
        return new TmpControlBuilder<FileConfig>(ApprovalCtrlType.FILE, title);
    }

    public static TmpControlBuilder<TableConfig> table(String title) {
        return new TmpControlBuilder<TableConfig>(ApprovalCtrlType.TABLE, title);
    }

    public static TmpControlBuilder<AttendanceConfig> attendance(String title) {
        return new TmpControlBuilder<AttendanceConfig>(ApprovalCtrlType.ATTENDANCE, title);
    }

    public static TmpControlBuilder<VacationConfig> vacation(String title) {
        return new TmpControlBuilder<VacationConfig>(ApprovalCtrlType.VACATION, title);
    }

    public static TmpControlBuilder<LocationConfig> location(String title) {
        return new TmpControlBuilder<LocationConfig>(ApprovalCtrlType.LOCATION, title);
    }

    public static TmpControlBuilder<RelatedApprovalConfig> relatedApproval(String title) {
        return new TmpControlBuilder<RelatedApprovalConfig>(ApprovalCtrlType.RELATED_APPROVAL, title);
    }

    public static TmpControlBuilder<FormulaConfig> formula(String title) {
        return new TmpControlBuilder<FormulaConfig>(ApprovalCtrlType.FORMULA, title);
    }

    public static TmpControlBuilder<EmptyConfig> phoneNumber(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.PHONE_NUMBER, title);
    }

    public static TmpControlBuilder<DateRangeConfig> dateRange(String title) {
        return new TmpControlBuilder<DateRangeConfig>(ApprovalCtrlType.DATE_RANGE, title);
    }

    public static TmpControlBuilder<EmptyConfig> bankAccount(String title) {
        return new TmpControlBuilder<EmptyConfig>(ApprovalCtrlType.BANK_ACCOUNT, title);
    }

    public TmpControl<C> build(C config) {
        String id = this.control.getType().concat("-").concat(String.valueOf(RANDOM.nextInt(999999999)));
        CtrlProperty property = new CtrlProperty(this.control, id, this.title);
        property.setPlaceholder(this.placeholder);
        property.setRequire(this.require);
        property.setUnPrint(this.unPrint);
        return new TmpControl<C>(property, config);
    }
}

