/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.approval.CtrlOption;
import cn.felord.domain.approval.DateRangeWrapper;
import cn.felord.domain.approval.SliceInfo;
import cn.felord.enumeration.AttendanceType;
import cn.felord.enumeration.SelectType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;

public class VacationValue
implements ContentDataValue {
    private final Wrapper vacation;

    @JsonCreator
    VacationValue(@JsonProperty(value="vacation") Wrapper vacation) {
        this.vacation = vacation;
    }

    public static VacationValue from(String key, AttendanceType attendanceType, DateRangeWrapper dateRange) {
        CtrlOption options = new CtrlOption();
        options.setKey(key);
        return new VacationValue(new Wrapper(options, attendanceType, dateRange));
    }

    public static VacationValue leave(String key, DateRangeWrapper dateRange) {
        return VacationValue.from(key, AttendanceType.LEAVE, dateRange);
    }

    public static VacationValue trip(String key, DateRangeWrapper dateRange) {
        return VacationValue.from(key, AttendanceType.BUSINESS_TRIP, dateRange);
    }

    public static VacationValue goingOut(String key, DateRangeWrapper dateRange) {
        return VacationValue.from(key, AttendanceType.GOING_OUT, dateRange);
    }

    public static VacationValue overtime(String key, DateRangeWrapper dateRange) {
        return VacationValue.from(key, AttendanceType.OVERTIME_WORK, dateRange);
    }

    public String toString() {
        return "VacationValue(vacation=" + this.getVacation() + ")";
    }

    public Wrapper getVacation() {
        return this.vacation;
    }

    public static class Attendance {
        private final AttendanceType type;
        private final DateRangeWrapper dateRange;
        private final SliceInfo sliceInfo;

        @JsonCreator
        Attendance(@JsonProperty(value="type") AttendanceType type, @JsonProperty(value="date_range") DateRangeWrapper dateRange, @JsonProperty(value="slice_info") SliceInfo sliceInfo) {
            this.type = type;
            this.dateRange = dateRange;
            this.sliceInfo = sliceInfo;
        }

        public String toString() {
            return "VacationValue.Attendance(type=" + (Object)((Object)this.getType()) + ", dateRange=" + this.getDateRange() + ", sliceInfo=" + this.getSliceInfo() + ")";
        }

        public AttendanceType getType() {
            return this.type;
        }

        public DateRangeWrapper getDateRange() {
            return this.dateRange;
        }

        public SliceInfo getSliceInfo() {
            return this.sliceInfo;
        }
    }

    public static class Selector {
        private final SelectType type = SelectType.SINGLE;
        private final List<CtrlOption> options;

        @JsonCreator
        Selector(@JsonProperty(value="options") List<CtrlOption> options) {
            this.options = options;
        }

        public String toString() {
            return "VacationValue.Selector(type=" + (Object)((Object)this.getType()) + ", options=" + this.getOptions() + ")";
        }

        public SelectType getType() {
            return this.type;
        }

        public List<CtrlOption> getOptions() {
            return this.options;
        }
    }

    public static class Wrapper {
        private final Selector selector;
        private final Attendance attendance;

        @JsonCreator
        Wrapper(@JsonProperty(value="selector") Selector selector, @JsonProperty(value="attendance") Attendance attendance) {
            this.selector = selector;
            this.attendance = attendance;
        }

        Wrapper(CtrlOption options, AttendanceType type, DateRangeWrapper dateRange) {
            this(new Selector(Collections.singletonList(options)), new Attendance(type, dateRange, null));
        }

        public String toString() {
            return "VacationValue.Wrapper(selector=" + this.getSelector() + ", attendance=" + this.getAttendance() + ")";
        }

        public Selector getSelector() {
            return this.selector;
        }

        public Attendance getAttendance() {
            return this.attendance;
        }
    }
}

