/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.approval;

import cn.felord.domain.approval.ContentDataValue;
import cn.felord.domain.wedrive.FileId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;

public class WedriveFileValue
implements ContentDataValue {
    private final List<FileId> wedriveFiles;

    @JsonCreator
    WedriveFileValue(@JsonProperty(value="wedrive_files") List<FileId> wedriveFiles) {
        this.wedriveFiles = wedriveFiles;
    }

    public static WedriveFileValue from(List<String> fileIds) {
        List<FileId> fileIdList = fileIds.stream().map(FileId::new).collect(Collectors.toList());
        return new WedriveFileValue(fileIdList);
    }

    public String toString() {
        return "WedriveFileValue(wedriveFiles=" + this.getWedriveFiles() + ")";
    }

    public List<FileId> getWedriveFiles() {
        return this.wedriveFiles;
    }
}

