/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.callcenter.knowledge;

import cn.felord.domain.callcenter.knowledge.Answer;
import cn.felord.domain.callcenter.knowledge.SimilarQuestions;
import cn.felord.domain.callcenter.knowledge.TextQuestion;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class Intent {
    private final String groupId;
    private final TextQuestion question;
    private final List<Answer> answers;
    private final SimilarQuestions similarQuestions;

    public Intent(String groupId, String content, List<Answer> answers) {
        this(groupId, content, answers, null);
    }

    public Intent(String groupId, String content, List<Answer> answers, List<String> similarQuestionContents) {
        this(groupId, TextQuestion.from(content), answers, SimilarQuestions.from(similarQuestionContents));
    }

    @JsonCreator
    Intent(@JsonProperty(value="group_id") String groupId, @JsonProperty(value="question") TextQuestion question, @JsonProperty(value="answers") List<Answer> answers, @JsonProperty(value="similar_questions") SimilarQuestions similarQuestions) {
        this.groupId = groupId;
        this.question = question;
        this.similarQuestions = similarQuestions;
        this.answers = answers;
    }

    public String toString() {
        return "Intent(groupId=" + this.getGroupId() + ", question=" + this.getQuestion() + ", answers=" + this.getAnswers() + ", similarQuestions=" + this.getSimilarQuestions() + ")";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public TextQuestion getQuestion() {
        return this.question;
    }

    public List<Answer> getAnswers() {
        return this.answers;
    }

    public SimilarQuestions getSimilarQuestions() {
        return this.similarQuestions;
    }
}

