/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.corpay.internal;

import cn.felord.WeComException;
import cn.felord.callback.XmlEntity;
import cn.felord.domain.corpay.internal.XmlRequest;
import cn.felord.enumeration.PaySignType;
import cn.felord.retrofit.json.JacksonObjectMapperFactory;
import cn.felord.utils.Algorithms;
import cn.felord.utils.CollectionUtils;
import cn.felord.utils.StringUtils;
import cn.felord.xml.XStreamXmlReader;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class AbstractXmlRequest
implements XmlRequest {
    private static final TypeReference<TreeMap<String, String>> TYPE_REFERENCE = new TypeReference<TreeMap<String, String>>(){};
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    @XStreamAlias(value="workwx_sign")
    private String workWxSign;
    @XStreamAlias(value="sign")
    private String sign;

    @Override
    public String xmlBody(String paySecret, PaySignType signType) {
        try {
            String json = MAPPER.writeValueAsString((Object)this);
            TreeMap treeMap = (TreeMap)MAPPER.readValue(json, TYPE_REFERENCE);
            String src = treeMap.entrySet().stream().filter(entry -> StringUtils.hasText((String)((String)entry.getValue()))).map(entry -> ((String)entry.getKey()).concat("=").concat((String)entry.getValue())).collect(Collectors.joining("&")).concat("&key=").concat(paySecret);
            this.sign = Objects.equals((Object)PaySignType.MD5, (Object)signType) ? Algorithms.md5Hex((String)src, (boolean)true) : Algorithms.hmacSha256Hex((String)src, (String)paySecret, (boolean)true);
            return XStreamXmlReader.INSTANCE.write((XmlEntity)this);
        }
        catch (JsonProcessingException e) {
            throw new WeComException("fail to parse xml", e);
        }
    }

    @Override
    public void workWxSign(String payAgentSecret) {
        TreeMap<String, String> signParams = this.signParams();
        if (CollectionUtils.isNotEmpty(signParams)) {
            String src = signParams.entrySet().stream().filter(entry -> StringUtils.hasText((String)((String)entry.getValue()))).map(entry -> ((String)entry.getKey()).concat("=").concat((String)entry.getValue())).collect(Collectors.joining("&")).concat("&secret=").concat(payAgentSecret);
            this.workWxSign = Algorithms.md5Hex((String)src, (boolean)true);
        }
    }

    protected TreeMap<String, String> signParams() {
        return null;
    }

    public String getSign() {
        return this.sign;
    }

    public String getWorkwxSign() {
        return this.workWxSign;
    }
}

