/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.externalcontact;

import cn.felord.domain.externalcontact.ContentText;
import cn.felord.domain.externalcontact.ImageMomentAttachment;
import cn.felord.domain.externalcontact.LinkMomentAttachment;
import cn.felord.domain.externalcontact.MomentAttachment;
import cn.felord.domain.externalcontact.VideoMomentAttachment;
import cn.felord.domain.externalcontact.VisibleRange;
import cn.felord.utils.StringUtils;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class MomentBody<T extends MomentAttachment> {
    private final VisibleRange visibleRange;
    private ContentText text;
    private Set<T> attachments;

    MomentBody(VisibleRange visibleRange) {
        this.visibleRange = visibleRange;
    }

    public static MomentBody<MomentAttachment> textMoment(String content) {
        return MomentBody.textMoment(content, null);
    }

    public static MomentBody<MomentAttachment> textMoment(String content, VisibleRange visibleRange) {
        MomentBody<MomentAttachment> momentAttachmentMomentBody = new MomentBody<MomentAttachment>(visibleRange);
        super.setText(new ContentText(content));
        return momentAttachmentMomentBody;
    }

    public static MomentBody<MomentAttachment> imageMoment(Set<String> imageMediaIds) {
        return MomentBody.imageMoment(imageMediaIds, null);
    }

    public static MomentBody<MomentAttachment> imageMoment(Set<String> imageMediaIds, VisibleRange visibleRange) {
        return MomentBody.imageMoment(null, imageMediaIds, visibleRange);
    }

    public static MomentBody<MomentAttachment> imageMoment(String content, Set<String> imageMediaIds, VisibleRange visibleRange) {
        MomentBody<MomentAttachment> imageMomentAttachmentMomentBody = new MomentBody<MomentAttachment>(visibleRange);
        if (StringUtils.hasText((String)content)) {
            super.setText(new ContentText(content));
        }
        Set momentAttachments = imageMediaIds.stream().map(ImageMomentAttachment::new).collect(Collectors.toSet());
        super.setAttachments(momentAttachments);
        return imageMomentAttachmentMomentBody;
    }

    public static MomentBody<MomentAttachment> videoMoment(String videoMediaId) {
        return MomentBody.videoMoment(videoMediaId, null);
    }

    public static MomentBody<MomentAttachment> videoMoment(String videoMediaId, VisibleRange visibleRange) {
        return MomentBody.videoMoment(null, videoMediaId, visibleRange);
    }

    public static MomentBody<MomentAttachment> videoMoment(String content, String videoMediaId, VisibleRange visibleRange) {
        MomentBody<MomentAttachment> videoMomentAttachmentMomentBody = new MomentBody<MomentAttachment>(visibleRange);
        if (StringUtils.hasText((String)content)) {
            super.setText(new ContentText(content));
        }
        super.setAttachments(Collections.singleton(new VideoMomentAttachment(videoMediaId)));
        return videoMomentAttachmentMomentBody;
    }

    public static MomentBody<MomentAttachment> linkMoment(LinkMomentAttachment linkMomentAttachment) {
        return MomentBody.linkMoment(linkMomentAttachment, null);
    }

    public static MomentBody<MomentAttachment> linkMoment(LinkMomentAttachment linkMomentAttachment, VisibleRange visibleRange) {
        return MomentBody.linkMoment(null, linkMomentAttachment, visibleRange);
    }

    public static MomentBody<MomentAttachment> linkMoment(String content, LinkMomentAttachment linkMomentAttachment, VisibleRange visibleRange) {
        MomentBody<MomentAttachment> linkMomentAttachmentMomentBody = new MomentBody<MomentAttachment>(visibleRange);
        if (StringUtils.hasText((String)content)) {
            super.setText(new ContentText(content));
        }
        super.setAttachments(Collections.singleton(linkMomentAttachment));
        return linkMomentAttachmentMomentBody;
    }

    private void setText(ContentText text) {
        this.text = text;
    }

    private void setAttachments(Set<T> attachments) {
        this.attachments = attachments;
    }

    public String toString() {
        return "MomentBody(visibleRange=" + this.getVisibleRange() + ", text=" + this.getText() + ", attachments=" + this.getAttachments() + ")";
    }

    public VisibleRange getVisibleRange() {
        return this.visibleRange;
    }

    public ContentText getText() {
        return this.text;
    }

    public Set<T> getAttachments() {
        return this.attachments;
    }
}

