/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.meetingroom;

import cn.felord.domain.meetingroom.Coordinate;
import cn.felord.domain.meetingroom.Range;
import cn.felord.enumeration.EquipmentType;
import java.util.ArrayList;
import java.util.List;

public class RoomUpdateRequest {
    private final Integer meetingroomId;
    private String name;
    private Integer capacity;
    private String city;
    private String building;
    private String floor;
    private List<EquipmentType> equipment;
    private Coordinate coordinate;
    private Range range;

    public RoomUpdateRequest(int meetingroomId) {
        this.meetingroomId = meetingroomId;
    }

    public RoomUpdateRequest name(String name) {
        this.name = name;
        return this;
    }

    public RoomUpdateRequest city(String city) {
        this.city = city;
        return this;
    }

    public RoomUpdateRequest capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public RoomUpdateRequest building(String building) {
        this.building = building;
        return this;
    }

    public RoomUpdateRequest floor(String floor) {
        this.floor = floor;
        return this;
    }

    public RoomUpdateRequest equipment(List<EquipmentType> equipment) {
        this.equipment = equipment;
        return this;
    }

    public RoomUpdateRequest coordinate(String latitude, String longitude) {
        this.coordinate = new Coordinate(latitude, longitude);
        return this;
    }

    public RoomUpdateRequest range(List<Integer> departmentList) {
        this.range = new Range(departmentList, null);
        return this;
    }

    public RoomUpdateRequest range(ArrayList<String> userList) {
        this.range = new Range(null, userList);
        return this;
    }

    public RoomUpdateRequest range(List<Integer> departmentList, List<String> userList) {
        this.range = new Range(departmentList, userList);
        return this;
    }

    public String toString() {
        return "RoomUpdateRequest(meetingroomId=" + this.getMeetingroomId() + ", name=" + this.getName() + ", capacity=" + this.getCapacity() + ", city=" + this.getCity() + ", building=" + this.getBuilding() + ", floor=" + this.getFloor() + ", equipment=" + this.getEquipment() + ", coordinate=" + this.getCoordinate() + ", range=" + this.getRange() + ")";
    }

    public Integer getMeetingroomId() {
        return this.meetingroomId;
    }

    public String getName() {
        return this.name;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public String getCity() {
        return this.city;
    }

    public String getBuilding() {
        return this.building;
    }

    public String getFloor() {
        return this.floor;
    }

    public List<EquipmentType> getEquipment() {
        return this.equipment;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Range getRange() {
        return this.range;
    }
}

