/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.message;

import cn.felord.domain.message.AbstractCard;
import cn.felord.domain.message.Select;
import cn.felord.domain.message.SubmitButton;
import cn.felord.domain.webhook.card.CardSource;
import cn.felord.domain.webhook.card.MainTitle;
import cn.felord.enumeration.TemplateCardType;
import java.util.List;

public class MultipleMessageTemplateCard
extends AbstractCard {
    private final List<Select> selectList;
    private final SubmitButton submitButton;

    protected MultipleMessageTemplateCard(String taskId, MainTitle mainTitle, CardSource source, List<Select> selectList, SubmitButton submitButton) {
        super(TemplateCardType.MULTIPLE_INTERACTION, taskId, mainTitle, source);
        this.selectList = selectList;
        this.submitButton = submitButton;
    }

    @Override
    public String toString() {
        return "MultipleMessageTemplateCard(selectList=" + this.getSelectList() + ", submitButton=" + this.getSubmitButton() + ")";
    }

    public List<Select> getSelectList() {
        return this.selectList;
    }

    public SubmitButton getSubmitButton() {
        return this.submitButton;
    }

    public static class Builder {
        private final String taskId;
        private final MainTitle mainTitle;
        private final List<Select> selectList;
        private final SubmitButton submitButton;
        private CardSource source;

        protected Builder(String taskId, MainTitle mainTitle, List<Select> selectList, SubmitButton submitButton) {
            this.taskId = taskId;
            this.mainTitle = mainTitle;
            this.selectList = selectList;
            this.submitButton = submitButton;
        }

        public Builder source(CardSource source) {
            this.source = source;
            return this;
        }

        public MultipleMessageTemplateCard build() {
            return new MultipleMessageTemplateCard(this.taskId, this.mainTitle, this.source, this.selectList, this.submitButton);
        }
    }
}

