/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.message;

import cn.felord.domain.message.ActionMenu;
import cn.felord.domain.message.MessageTemplateCard;
import cn.felord.domain.webhook.card.CardAction;
import cn.felord.domain.webhook.card.CardImage;
import cn.felord.domain.webhook.card.CardSource;
import cn.felord.domain.webhook.card.EmphasisContent;
import cn.felord.domain.webhook.card.HorizontalContent;
import cn.felord.domain.webhook.card.ImageTextArea;
import cn.felord.domain.webhook.card.Jump;
import cn.felord.domain.webhook.card.MainTitle;
import cn.felord.domain.webhook.card.QuoteArea;
import cn.felord.enumeration.TemplateCardType;
import java.util.List;

public class NewsMessageTemplateCard
extends MessageTemplateCard {
    private final ImageTextArea imageTextArea;
    private final CardImage cardImage;
    private final List<EmphasisContent> verticalContentList;

    public NewsMessageTemplateCard(String taskId, MainTitle mainTitle, CardSource source, ActionMenu actionMenu, QuoteArea quoteArea, List<? extends HorizontalContent> horizontalContentList, List<? extends Jump> jumpList, CardAction cardAction, ImageTextArea imageTextArea, CardImage cardImage, List<EmphasisContent> verticalContentList) {
        super(TemplateCardType.NEWS_NOTICE, taskId, mainTitle, source, actionMenu, quoteArea, horizontalContentList, jumpList, cardAction);
        this.imageTextArea = imageTextArea;
        this.cardImage = cardImage;
        this.verticalContentList = verticalContentList;
    }

    @Override
    public String toString() {
        return "NewsMessageTemplateCard(imageTextArea=" + this.getImageTextArea() + ", cardImage=" + this.getCardImage() + ", verticalContentList=" + this.getVerticalContentList() + ")";
    }

    public ImageTextArea getImageTextArea() {
        return this.imageTextArea;
    }

    public CardImage getCardImage() {
        return this.cardImage;
    }

    public List<EmphasisContent> getVerticalContentList() {
        return this.verticalContentList;
    }

    public static class Builder {
        private final CardAction cardAction;
        private final MainTitle mainTitle;
        private String taskId;
        private CardSource source;
        private ActionMenu actionMenu;
        private QuoteArea quoteArea;
        private List<? extends HorizontalContent> horizontalContentList;
        private List<? extends Jump> jumpList;
        private ImageTextArea imageTextArea;
        private CardImage cardImage;
        private List<EmphasisContent> verticalContentList;

        protected Builder(MainTitle mainTitle, CardAction cardAction) {
            this.mainTitle = mainTitle;
            this.cardAction = cardAction;
        }

        public Builder source(CardSource source) {
            this.source = source;
            return this;
        }

        public Builder actionMenu(String taskId, ActionMenu actionMenu) {
            this.taskId = taskId;
            this.actionMenu = actionMenu;
            return this;
        }

        public Builder quoteArea(QuoteArea quoteArea) {
            this.quoteArea = quoteArea;
            return this;
        }

        public Builder horizontalContentList(List<? extends HorizontalContent> horizontalContentList) {
            this.horizontalContentList = horizontalContentList;
            return this;
        }

        public Builder jumpList(List<? extends Jump> jumpList) {
            this.jumpList = jumpList;
            return this;
        }

        public Builder imageTextArea(ImageTextArea imageTextArea) {
            this.imageTextArea = imageTextArea;
            return this;
        }

        public Builder cardImage(CardImage cardImage) {
            this.cardImage = cardImage;
            return this;
        }

        public Builder verticalContentList(List<EmphasisContent> verticalContentList) {
            this.verticalContentList = verticalContentList;
            return this;
        }

        public NewsMessageTemplateCard build() {
            return new NewsMessageTemplateCard(this.taskId, this.mainTitle, this.source, this.actionMenu, this.quoteArea, this.horizontalContentList, this.jumpList, this.cardAction, this.imageTextArea, this.cardImage, this.verticalContentList);
        }
    }
}

