/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.oa;

import cn.felord.enumeration.BoolEnum;
import cn.felord.enumeration.DayOfMonth;
import cn.felord.enumeration.RemindBeforeEventSecs;
import cn.felord.enumeration.RemindTimeDiff;
import cn.felord.enumeration.RepeatType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.DayOfWeek;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Reminders {
    private BoolEnum isRemind;
    private BoolEnum isRepeat;
    private RemindBeforeEventSecs remindBeforeEventSecs;
    private List<RemindTimeDiff> remindTimeDiffs;
    private RepeatType repeatType;
    private Instant repeatUntil;
    private BoolEnum isCustomRepeat;
    private Integer repeatInterval;
    private List<DayOfMonth> repeatDayOfMonth;
    private List<Integer> repeatDayOfWeek;
    private Integer timezone;

    public Reminders() {
    }

    @JsonCreator
    Reminders(@JsonProperty(value="is_remind") BoolEnum isRemind, @JsonProperty(value="is_repeat") BoolEnum isRepeat, @JsonProperty(value="remind_before_event_secs") RemindBeforeEventSecs remindBeforeEventSecs, @JsonProperty(value="remind_time_diffs") List<RemindTimeDiff> remindTimeDiffs, @JsonProperty(value="repeat_type") RepeatType repeatType, @JsonProperty(value="repeat_until") Instant repeatUntil, @JsonProperty(value="is_custom_repeat") BoolEnum isCustomRepeat, @JsonProperty(value="repeat_interval") Integer repeatInterval, @JsonProperty(value="repeat_day_of_month") List<DayOfMonth> repeatDayOfMonth, @JsonProperty(value="repeat_day_of_week") List<Integer> repeatDayOfWeek, @JsonProperty(value="timezone") Integer timezone) {
        this.isRemind = isRemind;
        this.isRepeat = isRepeat;
        this.remindBeforeEventSecs = remindBeforeEventSecs;
        this.remindTimeDiffs = remindTimeDiffs;
        this.repeatType = repeatType;
        this.repeatUntil = repeatUntil;
        this.isCustomRepeat = isCustomRepeat;
        this.repeatInterval = repeatInterval;
        this.repeatDayOfMonth = repeatDayOfMonth;
        this.repeatDayOfWeek = repeatDayOfWeek;
        this.timezone = timezone;
    }

    public Reminders remind() {
        this.isRemind = BoolEnum.TRUE;
        return this;
    }

    public Reminders remind(List<RemindTimeDiff> remindTimeDiffs) {
        this.isRemind = BoolEnum.TRUE;
        this.remindTimeDiffs = remindTimeDiffs;
        return this;
    }

    public Reminders remind(RemindBeforeEventSecs remindBeforeEventSecs) {
        this.isRemind = BoolEnum.TRUE;
        this.remindBeforeEventSecs = remindBeforeEventSecs;
        return this;
    }

    public Reminders repeat() {
        this.isRepeat = BoolEnum.TRUE;
        return this;
    }

    public Reminders repeat(RepeatType repeatType) {
        this.isRepeat = BoolEnum.TRUE;
        this.repeatType = repeatType;
        return this;
    }

    public Reminders repeat(RepeatType repeatType, Instant repeatUntil) {
        this.isRepeat = BoolEnum.TRUE;
        this.repeatType = repeatType;
        this.repeatUntil = repeatUntil;
        return this;
    }

    public Reminders repeat(RepeatType repeatType, int repeatInterval) {
        this.isRepeat = BoolEnum.TRUE;
        this.isCustomRepeat = BoolEnum.TRUE;
        this.repeatType = repeatType;
        this.repeatInterval = repeatInterval;
        return this;
    }

    public Reminders repeat(List<DayOfWeek> dayOfWeek) {
        this.isRepeat = BoolEnum.TRUE;
        this.isCustomRepeat = BoolEnum.TRUE;
        this.repeatType = RepeatType.EACH_WEEK;
        this.repeatDayOfWeek = dayOfWeek.stream().map(DayOfWeek::getValue).collect(Collectors.toList());
        return this;
    }

    public Reminders repeat(ArrayList<DayOfMonth> dayOfMonth) {
        this.isRepeat = BoolEnum.TRUE;
        this.isCustomRepeat = BoolEnum.TRUE;
        this.repeatType = RepeatType.EACH_MONTH;
        this.repeatDayOfMonth = dayOfMonth;
        return this;
    }

    public Reminders timezone(int timezone) {
        this.timezone = timezone;
        return this;
    }

    public String toString() {
        return "Reminders(isRemind=" + (Object)((Object)this.getIsRemind()) + ", isRepeat=" + (Object)((Object)this.getIsRepeat()) + ", remindBeforeEventSecs=" + (Object)((Object)this.getRemindBeforeEventSecs()) + ", remindTimeDiffs=" + this.getRemindTimeDiffs() + ", repeatType=" + (Object)((Object)this.getRepeatType()) + ", repeatUntil=" + this.getRepeatUntil() + ", isCustomRepeat=" + (Object)((Object)this.getIsCustomRepeat()) + ", repeatInterval=" + this.getRepeatInterval() + ", repeatDayOfMonth=" + this.getRepeatDayOfMonth() + ", repeatDayOfWeek=" + this.getRepeatDayOfWeek() + ", timezone=" + this.getTimezone() + ")";
    }

    public BoolEnum getIsRemind() {
        return this.isRemind;
    }

    public BoolEnum getIsRepeat() {
        return this.isRepeat;
    }

    public RemindBeforeEventSecs getRemindBeforeEventSecs() {
        return this.remindBeforeEventSecs;
    }

    public List<RemindTimeDiff> getRemindTimeDiffs() {
        return this.remindTimeDiffs;
    }

    public RepeatType getRepeatType() {
        return this.repeatType;
    }

    public Instant getRepeatUntil() {
        return this.repeatUntil;
    }

    public BoolEnum getIsCustomRepeat() {
        return this.isCustomRepeat;
    }

    public Integer getRepeatInterval() {
        return this.repeatInterval;
    }

    public List<DayOfMonth> getRepeatDayOfMonth() {
        return this.repeatDayOfMonth;
    }

    public List<Integer> getRepeatDayOfWeek() {
        return this.repeatDayOfWeek;
    }

    public Integer getTimezone() {
        return this.timezone;
    }
}

