/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.oa;

import cn.felord.domain.common.UserId;
import cn.felord.domain.oa.Reminders;
import cn.felord.enumeration.BoolEnum;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ScheduleRequestBody {
    private final Instant startTime;
    private final Instant endTime;
    private Set<String> admins;
    private List<UserId> attendees;
    private String summary;
    private String description;
    private Reminders reminders;
    private String calId;
    private String location;
    private BoolEnum isWholeDay;

    public ScheduleRequestBody admins(Set<String> admins) {
        this.admins = admins;
        return this;
    }

    public ScheduleRequestBody attendees(List<String> attendees) {
        this.attendees = attendees.stream().map(UserId::new).collect(Collectors.toList());
        return this;
    }

    public ScheduleRequestBody summary(String summary) {
        this.summary = summary;
        return this;
    }

    public ScheduleRequestBody description(String description) {
        this.description = description;
        return this;
    }

    public ScheduleRequestBody reminders(Reminders reminders) {
        this.reminders = reminders;
        return this;
    }

    public ScheduleRequestBody calId(String calId) {
        this.calId = calId;
        return this;
    }

    public ScheduleRequestBody location(String location) {
        this.location = location;
        return this;
    }

    public ScheduleRequestBody isWholeDay(BoolEnum isWholeDay) {
        this.isWholeDay = isWholeDay;
        return this;
    }

    public String toString() {
        return "ScheduleRequestBody(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", admins=" + this.getAdmins() + ", attendees=" + this.getAttendees() + ", summary=" + this.getSummary() + ", description=" + this.getDescription() + ", reminders=" + this.getReminders() + ", calId=" + this.getCalId() + ", location=" + this.getLocation() + ", isWholeDay=" + (Object)((Object)this.getIsWholeDay()) + ")";
    }

    public ScheduleRequestBody(Instant startTime, Instant endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Set<String> getAdmins() {
        return this.admins;
    }

    public List<UserId> getAttendees() {
        return this.attendees;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public Reminders getReminders() {
        return this.reminders;
    }

    public String getCalId() {
        return this.calId;
    }

    public String getLocation() {
        return this.location;
    }

    public BoolEnum getIsWholeDay() {
        return this.isWholeDay;
    }
}

