/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.security;

import cn.felord.enumeration.DeviceType;
import java.util.Set;

public class TrustDevice {
    private final DeviceType type;
    private final String macAddr;
    private final String seqNo;
    private String motherboardUuid;
    private Set<String> harddiskUuid;
    private String domain;
    private String pcName;

    TrustDevice(DeviceType type, String macAddr, String seqNo) {
        this.type = type;
        this.macAddr = macAddr;
        this.seqNo = seqNo;
    }

    TrustDevice(DeviceType type, String macAddr, String seqNo, String motherboardUuid, Set<String> harddiskUuid, String domain, String pcName) {
        this.type = type;
        this.macAddr = macAddr;
        this.seqNo = seqNo;
        this.motherboardUuid = motherboardUuid;
        this.harddiskUuid = harddiskUuid;
        this.domain = domain;
        this.pcName = pcName;
    }

    public static TrustDevice mac(String seqNo) {
        return TrustDevice.mac(seqNo, null);
    }

    public static TrustDevice mac(String seqNo, String macAddr) {
        return new TrustDevice(DeviceType.MAC, seqNo, macAddr);
    }

    public static TrustDevice windows(String macAddr) {
        return TrustDevice.mac(null, macAddr);
    }

    public static TrustDevice windows(String macAddr, String seqNo) {
        return new TrustDevice(DeviceType.WINDOWS, seqNo, macAddr);
    }

    public TrustDevice motherboardUuid(String motherboardUuid) {
        this.motherboardUuid = motherboardUuid;
        return this;
    }

    public TrustDevice harddiskUuid(Set<String> harddiskUuid) {
        this.harddiskUuid = harddiskUuid;
        return this;
    }

    public TrustDevice domain(String domain) {
        this.domain = domain;
        return this;
    }

    public TrustDevice pcName(String pcName) {
        this.pcName = pcName;
        return this;
    }

    public String toString() {
        return "TrustDevice(type=" + (Object)((Object)this.getType()) + ", macAddr=" + this.getMacAddr() + ", seqNo=" + this.getSeqNo() + ", motherboardUuid=" + this.getMotherboardUuid() + ", harddiskUuid=" + this.getHarddiskUuid() + ", domain=" + this.getDomain() + ", pcName=" + this.getPcName() + ")";
    }

    public DeviceType getType() {
        return this.type;
    }

    public String getMacAddr() {
        return this.macAddr;
    }

    public String getSeqNo() {
        return this.seqNo;
    }

    public String getMotherboardUuid() {
        return this.motherboardUuid;
    }

    public Set<String> getHarddiskUuid() {
        return this.harddiskUuid;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPcName() {
        return this.pcName;
    }
}

