/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.webhook;

import cn.felord.domain.webhook.WebhookBody;
import cn.felord.utils.Algorithms;
import cn.felord.utils.Base64Utils;
import cn.felord.utils.FileTools;
import java.io.IOException;
import java.io.InputStream;

public class WebhookImageBody
extends WebhookBody {
    private final WebhookImage image;

    WebhookImageBody(WebhookImage image) {
        super("image");
        this.image = image;
    }

    public static WebhookImageBody from(InputStream imageStream) throws IOException {
        byte[] data = FileTools.copyToByteArray((InputStream)imageStream);
        String base64 = Base64Utils.encodeToString((byte[])data);
        String md5 = Algorithms.md5Hex((byte[])data, (boolean)false);
        return WebhookImageBody.from(base64, md5);
    }

    public static WebhookImageBody from(String base64, String md5) {
        return new WebhookImageBody(new WebhookImage(base64, md5));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookImageBody)) {
            return false;
        }
        WebhookImageBody other = (WebhookImageBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookImage this$image = this.getImage();
        WebhookImage other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookImageBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        WebhookImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebhookImageBody(image=" + this.getImage() + ")";
    }

    public WebhookImage getImage() {
        return this.image;
    }

    public static class WebhookImage {
        private final String base64;
        private final String md5;

        public String toString() {
            return "WebhookImageBody.WebhookImage(base64=" + this.getBase64() + ", md5=" + this.getMd5() + ")";
        }

        private WebhookImage(String base64, String md5) {
            this.base64 = base64;
            this.md5 = md5;
        }

        public String getBase64() {
            return this.base64;
        }

        public String getMd5() {
            return this.md5;
        }
    }
}

