/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.webhook;

import cn.felord.domain.webhook.WebhookBody;
import java.util.List;

public class WebhookTextBody
extends WebhookBody {
    private final WebhookText text;

    WebhookTextBody(WebhookText text) {
        super("text");
        this.text = text;
    }

    public static WebhookTextBody from(String content) {
        return WebhookTextBody.from(content, null);
    }

    public static WebhookTextBody from(String content, List<String> mentionedList) {
        return WebhookTextBody.from(content, mentionedList, null);
    }

    public static WebhookTextBody from(String content, List<String> mentionedList, List<String> mentionedMobileList) {
        WebhookText webhookText = new WebhookText(content);
        webhookText.setMentionedList(mentionedList);
        webhookText.setMentionedMobileList(mentionedMobileList);
        return new WebhookTextBody(webhookText);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookTextBody)) {
            return false;
        }
        WebhookTextBody other = (WebhookTextBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookText this$text = this.getText();
        WebhookText other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebhookTextBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        WebhookText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebhookTextBody(text=" + this.getText() + ")";
    }

    public WebhookText getText() {
        return this.text;
    }

    public static class WebhookText {
        private final String content;
        private List<String> mentionedList;
        private List<String> mentionedMobileList;

        public String toString() {
            return "WebhookTextBody.WebhookText(content=" + this.getContent() + ", mentionedList=" + this.getMentionedList() + ", mentionedMobileList=" + this.getMentionedMobileList() + ")";
        }

        public String getContent() {
            return this.content;
        }

        public List<String> getMentionedList() {
            return this.mentionedList;
        }

        public List<String> getMentionedMobileList() {
            return this.mentionedMobileList;
        }

        public void setMentionedList(List<String> mentionedList) {
            this.mentionedList = mentionedList;
        }

        public void setMentionedMobileList(List<String> mentionedMobileList) {
            this.mentionedMobileList = mentionedMobileList;
        }

        private WebhookText(String content) {
            this.content = content;
        }
    }
}

