/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum CallReason {
    RINGING(1),
    ANSWERED(2),
    IN_CALL(3),
    CALL_TIMEOUT_USER_HUNG_UP(4),
    OUT_OF_SERVICE_AREA(5),
    UNANSWERED_DUE_TO_UNPAID_BILLS(6),
    REJECTED_BY_CALLED_PARTY(7),
    CALLED_PARTY_PHONE_OFF(8),
    INVALID_NUMBER(9),
    CALL_RESTRICTED(10),
    LINE_ERROR(11),
    CALL_TIMEOUT_SYSTEM_HUNG_UP(12),
    EXCEEDED_CALL_LIMIT(13),
    LINE_TIMEOUT_WITHOUT_RESPONSE(14),
    EXCEEDED_LIMIT(15),
    LINE_BUSY_PLEASE_REDIAL_LATER(16),
    CALL_CANCELLED_NOTIFICATION(17),
    CALL_TIMEOUT_WITHOUT_CONFIRMATION(20),
    OTHER(99);

    private final int type;

    private CallReason(int type) {
        this.type = type;
    }

    @JsonValue
    public int getType() {
        return this.type;
    }

    @JsonCreator
    public static CallReason deserialize(int type) {
        return Arrays.stream(CallReason.values()).filter(callReason -> callReason.type == type).findFirst().orElse(null);
    }
}

