/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum RemindTimeDiff {
    BEGINNING(0),
    FIVE_MIN(300),
    FIFTEEN_MIN(900),
    ONE_HOUR(3600),
    ONE_DAY(86400),
    NINE_AM_ALL(86400),
    TWO_DAY_ALL(86400),
    ONE_WEEK_ALL(86400);

    private final int duration;

    private RemindTimeDiff(int duration) {
        this.duration = duration;
    }

    @JsonCreator
    public static RemindTimeDiff deserialize(int duration) {
        return Arrays.stream(RemindTimeDiff.values()).filter(responseduration -> responseduration.duration == duration).findFirst().orElse(null);
    }

    @JsonValue
    public int getDuration() {
        return this.duration;
    }
}

