/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum WechatChannelSource {
    UNKNOWN(0),
    HOME_PAGE(1),
    LIVE_ROOM(2),
    BUSINESS_SERVICE(3);

    private final int type;

    private WechatChannelSource(int type) {
        this.type = type;
    }

    @JsonValue
    public int getType() {
        return this.type;
    }

    @JsonCreator
    public static WechatChannelSource deserialize(int type) {
        return Arrays.stream(WechatChannelSource.values()).filter(contactType -> contactType.type == type).findFirst().orElse(null);
    }
}

