/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.AgentDetails;
import cn.felord.WeComException;
import cn.felord.WeComTokenCacheable;
import cn.felord.domain.authentication.AccessTokenResponse;
import cn.felord.retrofit.AbstractTokenApi;
import cn.felord.retrofit.RetrofitAccessTokenApi;
import cn.felord.retrofit.WecomUserAgent;
import cn.felord.retrofit.WorkWechatRetrofitFactory;

public class AccessTokenApi
extends AbstractTokenApi {
    private static final RetrofitAccessTokenApi TOKEN_API = (RetrofitAccessTokenApi)WorkWechatRetrofitFactory.RETROFIT_.create(RetrofitAccessTokenApi.class);

    public AccessTokenApi(WeComTokenCacheable wecomCacheable, AgentDetails agentDetails) {
        super(wecomCacheable, agentDetails);
    }

    @Override
    protected String doGetToken(AgentDetails agentDetails) {
        AccessTokenResponse tokenResponse = TOKEN_API.getTokenResponse(WecomUserAgent.WECOM_USER_AGENT, agentDetails.getCorpId(), agentDetails.getSecret());
        if (tokenResponse == null || tokenResponse.isError()) {
            String errorMsg = tokenResponse == null ? "token response is null" : tokenResponse.getErrmsg();
            throw new WeComException("failed to obtain access token,reason: " + errorMsg);
        }
        return tokenResponse.getAccessToken();
    }
}

