/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.AgentDetails;
import cn.felord.DownStreamDetails;
import cn.felord.WeComException;
import cn.felord.WeComTokenCacheable;
import cn.felord.domain.authentication.AccessTokenResponse;
import cn.felord.retrofit.AbstractTokenApi;
import cn.felord.retrofit.AccessTokenApi;
import cn.felord.retrofit.DownStreamAccessTokenApi;
import cn.felord.retrofit.WecomUserAgent;
import cn.felord.retrofit.WorkWechatRetrofitFactory;

public class DownStreamTokenApi
extends AbstractTokenApi {
    private static final DownStreamAccessTokenApi DOWNSTREAM_TOKEN_API = (DownStreamAccessTokenApi)WorkWechatRetrofitFactory.RETROFIT_.create(DownStreamAccessTokenApi.class);

    public DownStreamTokenApi(WeComTokenCacheable wecomCacheable, DownStreamDetails agentDetails) {
        super(wecomCacheable, agentDetails);
    }

    @Override
    protected String doGetToken(AgentDetails agentDetails) {
        DownStreamDetails downStreamDetails = (DownStreamDetails)agentDetails;
        AccessTokenApi tokenApi = new AccessTokenApi(this.getWecomCacheable(), downStreamDetails.getUpStreamDetails());
        String token = tokenApi.getToken();
        AccessTokenResponse tokenResponse = DOWNSTREAM_TOKEN_API.getTokenResponse(WecomUserAgent.WECOM_USER_AGENT, downStreamDetails.toRequest(), token);
        if (tokenResponse == null || tokenResponse.isError()) {
            String errorMsg = tokenResponse == null ? "downstream token response is null" : tokenResponse.getErrmsg();
            throw new WeComException("failed to obtain downstream access token,reason: " + errorMsg);
        }
        return tokenResponse.getAccessToken();
    }
}

