/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.WeComException;
import cn.felord.domain.WeComResponse;
import cn.felord.utils.StringUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.Headers;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

final class ResponseBodyCallAdapterFactory
extends CallAdapter.Factory {
    static final ResponseBodyCallAdapterFactory INSTANCE = new ResponseBodyCallAdapterFactory();

    private ResponseBodyCallAdapterFactory() {
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Class rawType = ResponseBodyCallAdapterFactory.getRawType((Type)returnType);
        if (Void.TYPE.isAssignableFrom(rawType)) {
            return null;
        }
        if (Response.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (Call.class.isAssignableFrom(rawType)) {
            return null;
        }
        if (CompletableFuture.class.isAssignableFrom(rawType)) {
            return null;
        }
        return new ResponseBodyCallAdapter(returnType);
    }

    static final class ResponseBodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private static final String ERROR_CODE_HEADER = "error-code";
        private static final String ERROR_MSG_HEADER = "error-msg";
        private static final String SUCCESS_CODE = "0";
        private final Type returnType;

        ResponseBodyCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            Response response;
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw new WeComException(e.getMessage(), e);
            }
            if (response.isSuccessful()) {
                Headers headers = response.headers();
                String errorCode = headers.get(ERROR_CODE_HEADER);
                if (StringUtils.hasText((String)errorCode)) {
                    if (!Objects.equals(SUCCESS_CODE, errorCode)) {
                        throw new WeComException(Integer.parseInt(errorCode), headers.get(ERROR_MSG_HEADER));
                    }
                } else {
                    WeComResponse weComResponse;
                    Object body = response.body();
                    if (body != null && WeComResponse.class.isAssignableFrom(body.getClass()) && (weComResponse = (WeComResponse)body).isError()) {
                        throw new WeComException(weComResponse.getErrcode(), weComResponse.getErrmsg());
                    }
                }
                return (R)response.body();
            }
            throw new WeComException("response is not successful, " + response.message());
        }
    }
}

