/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.WeComException;
import cn.felord.domain.WeComResponse;
import cn.felord.retrofit.AccessTokenApi;
import cn.felord.retrofit.TokenApi;
import cn.felord.retrofit.WecomUserAgent;
import cn.felord.retrofit.json.JacksonObjectMapperFactory;
import cn.felord.utils.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public class TokenInterceptor
implements Interceptor {
    private static final String INVALID_ACCESS_TOKEN = "42001";
    public static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    private static final MediaType JSON_UTF_8 = MediaType.parse((String)"application/json; charset=UTF-8");
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private static final String ERROR_CODE_HEADER = "error-code";
    private final TokenApi tokenApi;
    private final String tokenParam;
    private final boolean debug;

    public TokenInterceptor(TokenApi tokenApi) {
        this(tokenApi, false);
    }

    public TokenInterceptor(TokenApi tokenApi, boolean debug) {
        this.tokenApi = tokenApi;
        this.tokenParam = this.determineTokenParam(tokenApi.getClass());
        this.debug = debug;
    }

    @NotNull
    public final Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response = this.doRequest(chain);
        String errorCode = response.header(ERROR_CODE_HEADER);
        if (StringUtils.hasText((String)errorCode)) {
            if (Objects.equals(INVALID_ACCESS_TOKEN, errorCode)) {
                this.tokenApi.clearToken();
                response.close();
                return this.doRequest(chain);
            }
        } else {
            MediaType mediaType;
            ResponseBody body = response.body();
            if (body != null && (Objects.equals(JSON_UTF_8, mediaType = body.contentType()) || Objects.equals(JSON, mediaType))) {
                BufferedSource source = body.source();
                source.request(Long.MAX_VALUE);
                try (Buffer buffer = source.getBuffer().clone();){
                    String json = buffer.readUtf8();
                    WeComResponse weComResponse = (WeComResponse)MAPPER.readValue(json, WeComResponse.class);
                    if (Objects.equals(INVALID_ACCESS_TOKEN, String.valueOf(weComResponse.getErrcode()))) {
                        this.tokenApi.clearToken();
                        response.close();
                        Response response2 = this.doRequest(chain);
                        return response2;
                    }
                }
            }
        }
        return response;
    }

    private Response doRequest(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl oldHttpUrl = request.url();
        String tokenResponse = this.tokenApi.getToken();
        HttpUrl.Builder builder = oldHttpUrl.newBuilder().addQueryParameter(this.tokenParam, tokenResponse);
        if (this.debug) {
            builder.addQueryParameter("debug", "1");
        }
        HttpUrl httpUrl = builder.build();
        Request requestWithAccessToken = request.newBuilder().header("User-Agent", WecomUserAgent.WECOM_USER_AGENT).url(httpUrl).build();
        return chain.proceed(requestWithAccessToken);
    }

    private String determineTokenParam(Class<? extends TokenApi> tokenApiClazz) {
        if (AccessTokenApi.class.isAssignableFrom(tokenApiClazz)) {
            return "access_token";
        }
        throw new WeComException("the api is not supported");
    }
}

