/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    protected static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    protected static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return "null";
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    protected static Object stringToValue(String string) {
        if (null == string || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if (0 == string.length()) {
            return "";
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    protected static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value) {
        String[] path = StrUtil.splitToArray((CharSequence)Convert.toStr(key), '.');
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.set(segment, nextTarget);
            }
            target = nextTarget;
        }
        target.set(path[last], value);
        return jsonObject;
    }

    protected static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    protected static boolean isOrder(Object value) {
        JSONConfig config;
        if (value instanceof LinkedHashMap || value instanceof SortedMap) {
            return true;
        }
        if (value instanceof JSONGetter && null != (config = ((JSONGetter)value).getConfig())) {
            return config.isOrder();
        }
        return false;
    }
}

