/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.finder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.finder.TextFinder;
import cn.hutool.core.util.StrUtil;

public class StrFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final CharSequence str;
    private final boolean caseInsensitive;

    public StrFinder(CharSequence str, boolean caseInsensitive) {
        Assert.notEmpty(str);
        this.str = str;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        return StrUtil.indexOf(this.text, this.str, from, this.caseInsensitive);
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + this.str.length();
    }
}

