/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.AvgPartition;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.Partition;
import cn.hutool.core.collection.RandomAccessAvgPartition;
import cn.hutool.core.collection.RandomAccessPartition;
import cn.hutool.core.comparator.PinyinComparator;
import cn.hutool.core.comparator.PropertyComparator;
import cn.hutool.core.exceptions.ValidateException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Matcher;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ListUtil {
    public static <T> List<T> list(boolean isLinked) {
        return isLinked ? new LinkedList() : new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> list(boolean isLinked, T ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return ListUtil.list(isLinked);
        }
        AbstractList arrayList = isLinked ? new LinkedList() : new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    public static <T> List<T> list(boolean isLinked, Collection<T> collection) {
        if (null == collection) {
            return ListUtil.list(isLinked);
        }
        return isLinked ? new LinkedList<T>(collection) : new ArrayList<T>(collection);
    }

    public static <T> List<T> list(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListUtil.list(isLinked);
        }
        return ListUtil.list(isLinked, iterable.iterator());
    }

    public static <T> List<T> list(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListUtil.list(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> List<T> list(boolean isLinked, Enumeration<T> enumration) {
        List<T> list = ListUtil.list(isLinked);
        if (null != enumration) {
            while (enumration.hasMoreElements()) {
                list.add(enumration.nextElement());
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... values) {
        return (ArrayList)ListUtil.list(false, values);
    }

    @SafeVarargs
    public static <T> LinkedList<T> toLinkedList(T ... values) {
        return (LinkedList)ListUtil.list(true, values);
    }

    @SafeVarargs
    public static <T> List<T> of(T ... ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(ListUtil.toList(ts));
    }

    public static <T> CopyOnWriteArrayList<T> toCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> ArrayList<T> toList(Collection<T> collection) {
        return (ArrayList)ListUtil.list(false, collection);
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        return (ArrayList)ListUtil.list(false, iterable);
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        return (ArrayList)ListUtil.list(false, iterator);
    }

    public static <T> ArrayList<T> toList(Enumeration<T> enumeration) {
        return (ArrayList)ListUtil.list(false, enumeration);
    }

    public static <T> List<T> page(int pageNo, int pageSize, List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        int resultSize = list.size();
        if (resultSize <= pageSize) {
            if (pageNo < PageUtil.getFirstPageNo() + 1) {
                return ListUtil.unmodifiable(list);
            }
            return new ArrayList(0);
        }
        if ((long)(pageNo - PageUtil.getFirstPageNo()) * (long)pageSize > (long)resultSize) {
            return new ArrayList(0);
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
        if (startEnd[1] > resultSize) {
            startEnd[1] = resultSize;
            if (startEnd[0] > startEnd[1]) {
                return new ArrayList(0);
            }
        }
        return ListUtil.sub(list, startEnd[0], startEnd[1]);
    }

    public static <T> void page(List<T> list, int pageSize, Consumer<List<T>> pageListConsumer) {
        if (CollUtil.isEmpty(list) || pageSize <= 0) {
            return;
        }
        int total = list.size();
        int totalPage = PageUtil.totalPage(total, pageSize);
        for (int pageNo = PageUtil.getFirstPageNo(); pageNo < totalPage + PageUtil.getFirstPageNo(); ++pageNo) {
            int[] startEnd = PageUtil.transToStartEnd(pageNo, pageSize);
            if (startEnd[1] > total) {
                startEnd[1] = total;
            }
            pageListConsumer.accept(ListUtil.sub(list, startEnd[0], startEnd[1]));
        }
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        if (CollUtil.isEmpty(list)) {
            return list;
        }
        list.sort(c);
        return list;
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtil.sort(list, new PropertyComparator(property));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sort(list, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjectUtil.clone(list);
        if (null == list2) {
            list2 = new ArrayList<T>(list);
        }
        try {
            return ListUtil.reverse(list2);
        }
        catch (UnsupportedOperationException e) {
            return ListUtil.reverse(ListUtil.list(false, list));
        }
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        Assert.notNull(list, "List must be not null !", new Object[0]);
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element) {
        return ListUtil.setOrPadding(list, index, element, null);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement) {
        return ListUtil.setOrPadding(list, index, element, paddingElement, (list.size() + 1) * 10);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement, int indexLimit) {
        Assert.notNull(list, "List must be not null !", new Object[0]);
        int size = list.size();
        if (index < size) {
            list.set(index, element);
        } else {
            if (indexLimit > 0 && index > indexLimit) {
                throw new ValidateException("Index [{}] is too large for limit: [{}]", index, indexLimit);
            }
            for (int i = size; i < index; ++i) {
                list.add(paddingElement);
            }
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        return ListUtil.sub(list, start, end, 1);
    }

    public static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step < 1) {
            step = 1;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> int lastIndexOf(List<T> list, Matcher<T> matcher) {
        int size;
        if (null != list && (size = list.size()) > 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (null != matcher && !matcher.match(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int[] indexOfAll(List<T> list, Matcher<T> matcher) {
        return CollUtil.indexOfAll(list, matcher);
    }

    public static <T> List<T> unmodifiable(List<T> list) {
        if (null == list) {
            return null;
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    public static <T> List<List<T>> split(List<T> list, int size) {
        return ListUtil.partition(list, size);
    }

    public static <T> List<List<T>> splitAvg(List<T> list, int limit) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessAvgPartition<T>(list, limit) : new AvgPartition<T>(list, limit);
    }

    public static <T> void swapTo(List<T> list, T element, Integer targetIndex) {
        int index;
        if (CollUtil.isNotEmpty(list) && (index = list.indexOf(element)) >= 0) {
            Collections.swap(list, index, (int)targetIndex);
        }
    }

    public static <T> void swapElement(List<T> list, T element, T targetElement) {
        int targetIndex;
        if (CollUtil.isNotEmpty(list) && (targetIndex = list.indexOf(targetElement)) >= 0) {
            ListUtil.swapTo(list, element, targetIndex);
        }
    }
}

