/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.pooled;

import cn.hutool.db.ds.AbstractDSFactory;
import cn.hutool.db.ds.pooled.DbConfig;
import cn.hutool.db.ds.pooled.PooledDataSource;
import cn.hutool.setting.Setting;
import javax.sql.DataSource;

public class PooledDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 8093886210895248277L;
    public static final String DS_NAME = "Hutool-Pooled-DataSource";

    public PooledDSFactory() {
        this((Setting)null);
    }

    public PooledDSFactory(Setting setting) {
        super(DS_NAME, PooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DbConfig dbConfig = new DbConfig();
        dbConfig.setUrl(jdbcUrl);
        dbConfig.setDriver(driver);
        dbConfig.setUser(user);
        dbConfig.setPass(pass);
        dbConfig.setInitialSize(poolSetting.getInt((Object)"initialSize", Integer.valueOf(0)));
        dbConfig.setMinIdle(poolSetting.getInt((Object)"minIdle", Integer.valueOf(0)));
        dbConfig.setMaxActive(poolSetting.getInt((Object)"maxActive", Integer.valueOf(8)));
        dbConfig.setMaxWait(poolSetting.getLong((Object)"maxWait", Long.valueOf(6000L)));
        return new PooledDataSource(dbConfig);
    }
}

