/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db;

import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.db.sql.SqlLog;
import cn.hutool.log.level.Level;
import cn.hutool.setting.Setting;

public class GlobalDbConfig {
    private static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    private static final String DEFAULT_DB_SETTING_PATH2 = "db.setting";
    protected static boolean caseInsensitive = true;
    protected static boolean returnGeneratedKey = true;
    private static String dbSettingPath = null;

    public static void setCaseInsensitive(boolean isCaseInsensitive) {
        caseInsensitive = isCaseInsensitive;
    }

    public static void setReturnGeneratedKey(boolean isReturnGeneratedKey) {
        returnGeneratedKey = isReturnGeneratedKey;
    }

    public static void setDbSettingPath(String customDbSettingPath) {
        dbSettingPath = customDbSettingPath;
    }

    public static Setting createDbSetting() {
        Setting setting;
        if (null != dbSettingPath) {
            try {
                setting = new Setting(dbSettingPath, false);
            }
            catch (NoResourceException e3) {
                throw new NoResourceException("Customize db setting file [{}] not found !", new Object[]{dbSettingPath});
            }
        } else {
            setting = GlobalDbConfig.tryDefaultDbSetting();
        }
        return setting;
    }

    private static Setting tryDefaultDbSetting() {
        Object[] defaultDbSettingPaths;
        for (String string : defaultDbSettingPaths = new String[]{"file:config/db.setting", "file:db.setting", DEFAULT_DB_SETTING_PATH, DEFAULT_DB_SETTING_PATH2}) {
            try {
                return new Setting(string, true);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        throw new NoResourceException("Default db settings [{}] in classpath not found !", new Object[]{ArrayUtil.join((Object[])defaultDbSettingPaths, (CharSequence)",")});
    }

    public static void setShowSql(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        SqlLog.INSTANCE.init(isShowSql, isFormatSql, isShowParams, level);
    }
}

