/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.meta;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.Table;
import cn.hutool.db.meta.TableType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class MetaUtil {
    public static List<String> getTables(DataSource ds) {
        return MetaUtil.getTables(ds, TableType.TABLE);
    }

    public static List<String> getTables(DataSource ds, TableType ... types) {
        return MetaUtil.getTables(ds, null, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        return MetaUtil.getTables(ds, schema, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        ArrayList<String> tables = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, Convert.toStrArray((Object)types));){
                if (null != rs) {
                    while (rs.next()) {
                        String table = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                        tables.add(table);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            String schema = MetaUtil.getSchema(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            stringArray = columnNames.toArray(new String[0]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return Entity.create(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        return MetaUtil.getTableMeta(ds, null, null, tableName);
    }

    public static Table getTableMeta(DataSource ds, String catalog, String schema, String tableName) {
        Connection conn = null;
        try {
            conn = ds.getConnection();
            Table table = MetaUtil.getTableMeta(conn, catalog, schema, tableName);
            return table;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        finally {
            IoUtil.close((AutoCloseable)conn);
        }
    }

    public static Table getTableMeta(Connection conn, String catalog, String schema, String tableName) {
        Table table = Table.create(tableName);
        if (null == catalog) {
            catalog = MetaUtil.getCatalog(conn);
        }
        table.setCatalog(catalog);
        if (null == schema) {
            schema = MetaUtil.getSchema(conn);
        }
        table.setSchema(schema);
        DatabaseMetaData metaData = MetaUtil.getMetaData(conn);
        String pureTableName = MetaUtil.unWrapIfOracle(metaData, tableName);
        table.setComment(MetaUtil.getRemarks(metaData, catalog, schema, pureTableName));
        table.setPkNames(MetaUtil.getPrimaryKeys(metaData, catalog, schema, pureTableName));
        MetaUtil.fetchColumns(metaData, catalog, schema, table);
        Map<String, IndexInfo> indexInfoMap = MetaUtil.getIndexInfo(metaData, catalog, schema, tableName);
        table.setIndexInfoList(ListUtil.toList(indexInfoMap.values()));
        return table;
    }

    @Deprecated
    public static String getCataLog(Connection conn) {
        return MetaUtil.getCatalog(conn);
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static DatabaseMetaData getMetaData(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getMetaData();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRemarks(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        tableName = MetaUtil.unWrapIfOracle(metaData, tableName);
        try (ResultSet rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});){
            if (null == rs) return null;
            if (!rs.next()) return null;
            String string = rs.getString("REMARKS");
            return string;
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static Set<String> getPrimaryKeys(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        tableName = MetaUtil.unWrapIfOracle(metaData, tableName);
        LinkedHashSet<String> primaryKeys = null;
        try (ResultSet rs = metaData.getPrimaryKeys(catalog, schema, tableName);){
            if (null != rs) {
                primaryKeys = new LinkedHashSet<String>(rs.getFetchSize(), 1.0f);
                while (rs.next()) {
                    primaryKeys.add(rs.getString("COLUMN_NAME"));
                }
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return primaryKeys;
    }

    public static Map<String, IndexInfo> getIndexInfo(DatabaseMetaData metaData, String catalog, String schema, String tableName) {
        LinkedHashMap<String, IndexInfo> indexInfoMap = new LinkedHashMap<String, IndexInfo>();
        try (ResultSet rs = metaData.getIndexInfo(catalog, schema, tableName, false, false);){
            if (null != rs) {
                while (rs.next()) {
                    if (0 == rs.getShort("TYPE")) continue;
                    String indexName = rs.getString("INDEX_NAME");
                    String key = StrUtil.join((CharSequence)"&", (Object[])new Object[]{tableName, indexName});
                    IndexInfo indexInfo = (IndexInfo)indexInfoMap.get(key);
                    if (null == indexInfo) {
                        indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog);
                        indexInfoMap.put(key, indexInfo);
                    }
                    indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.create(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return indexInfoMap;
    }

    public static boolean isOracle(DatabaseMetaData metaData) throws DbRuntimeException {
        try {
            return StrUtil.equalsIgnoreCase((CharSequence)"Oracle", (CharSequence)metaData.getDatabaseProductName());
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    private static String unWrapIfOracle(DatabaseMetaData metaData, String tableName) {
        int wrapChar = 34;
        if (StrUtil.isWrap((CharSequence)tableName, (char)'\"') && MetaUtil.isOracle(metaData)) {
            tableName = StrUtil.unWrap((CharSequence)tableName, (char)'\"');
        }
        return tableName;
    }

    private static void fetchColumns(DatabaseMetaData metaData, String catalog, String schema, Table table) {
        String tableName = MetaUtil.unWrapIfOracle(metaData, table.getTableName());
        try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
            if (null != rs) {
                while (rs.next()) {
                    table.setColumn(Column.create(table, rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }
}

