/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.tokenizer.engine;

import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.tokenizer.TokenizerEngine;
import cn.hutool.extra.tokenizer.TokenizerException;
import cn.hutool.log.StaticLog;

public class TokenizerFactory {
    public static TokenizerEngine get() {
        return (TokenizerEngine)Singleton.get((String)TokenizerEngine.class.getName(), TokenizerFactory::create);
    }

    public static TokenizerEngine create() {
        TokenizerEngine engine = TokenizerFactory.doCreate();
        StaticLog.debug((String)"Use [{}] Tokenizer Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static TokenizerEngine doCreate() {
        TokenizerEngine engine = (TokenizerEngine)ServiceLoaderUtil.loadFirstAvailable(TokenizerEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TokenizerException("No tokenizer found ! Please add some tokenizer jar to your project !");
    }
}

