/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.converters;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.converters.ConverterKeyBuild;
import cn.idev.excel.converters.bigdecimal.BigDecimalBooleanConverter;
import cn.idev.excel.converters.bigdecimal.BigDecimalNumberConverter;
import cn.idev.excel.converters.bigdecimal.BigDecimalStringConverter;
import cn.idev.excel.converters.biginteger.BigIntegerBooleanConverter;
import cn.idev.excel.converters.biginteger.BigIntegerNumberConverter;
import cn.idev.excel.converters.biginteger.BigIntegerStringConverter;
import cn.idev.excel.converters.booleanconverter.BooleanBooleanConverter;
import cn.idev.excel.converters.booleanconverter.BooleanNumberConverter;
import cn.idev.excel.converters.booleanconverter.BooleanStringConverter;
import cn.idev.excel.converters.bytearray.BoxingByteArrayImageConverter;
import cn.idev.excel.converters.bytearray.ByteArrayImageConverter;
import cn.idev.excel.converters.byteconverter.ByteBooleanConverter;
import cn.idev.excel.converters.byteconverter.ByteNumberConverter;
import cn.idev.excel.converters.byteconverter.ByteStringConverter;
import cn.idev.excel.converters.date.DateDateConverter;
import cn.idev.excel.converters.date.DateNumberConverter;
import cn.idev.excel.converters.date.DateStringConverter;
import cn.idev.excel.converters.doubleconverter.DoubleBooleanConverter;
import cn.idev.excel.converters.doubleconverter.DoubleNumberConverter;
import cn.idev.excel.converters.doubleconverter.DoubleStringConverter;
import cn.idev.excel.converters.file.FileImageConverter;
import cn.idev.excel.converters.floatconverter.FloatBooleanConverter;
import cn.idev.excel.converters.floatconverter.FloatNumberConverter;
import cn.idev.excel.converters.floatconverter.FloatStringConverter;
import cn.idev.excel.converters.inputstream.InputStreamImageConverter;
import cn.idev.excel.converters.integer.IntegerBooleanConverter;
import cn.idev.excel.converters.integer.IntegerNumberConverter;
import cn.idev.excel.converters.integer.IntegerStringConverter;
import cn.idev.excel.converters.localdate.LocalDateDateConverter;
import cn.idev.excel.converters.localdate.LocalDateNumberConverter;
import cn.idev.excel.converters.localdate.LocalDateStringConverter;
import cn.idev.excel.converters.localdatetime.LocalDateTimeDateConverter;
import cn.idev.excel.converters.localdatetime.LocalDateTimeNumberConverter;
import cn.idev.excel.converters.localdatetime.LocalDateTimeStringConverter;
import cn.idev.excel.converters.longconverter.LongBooleanConverter;
import cn.idev.excel.converters.longconverter.LongNumberConverter;
import cn.idev.excel.converters.longconverter.LongStringConverter;
import cn.idev.excel.converters.shortconverter.ShortBooleanConverter;
import cn.idev.excel.converters.shortconverter.ShortNumberConverter;
import cn.idev.excel.converters.shortconverter.ShortStringConverter;
import cn.idev.excel.converters.string.StringBooleanConverter;
import cn.idev.excel.converters.string.StringErrorConverter;
import cn.idev.excel.converters.string.StringNumberConverter;
import cn.idev.excel.converters.string.StringStringConverter;
import cn.idev.excel.converters.url.UrlImageConverter;
import cn.idev.excel.util.MapUtils;
import java.util.Map;

public class DefaultConverterLoader {
    private static Map<ConverterKeyBuild.ConverterKey, Converter<?>> defaultWriteConverter;
    private static Map<ConverterKeyBuild.ConverterKey, Converter<?>> allConverter;

    private static void initAllConverter() {
        allConverter = MapUtils.newHashMapWithExpectedSize(40);
        DefaultConverterLoader.putAllConverter(new BigDecimalBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalStringConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerNumberConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerStringConverter());
        DefaultConverterLoader.putAllConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BooleanNumberConverter());
        DefaultConverterLoader.putAllConverter(new BooleanStringConverter());
        DefaultConverterLoader.putAllConverter(new ByteBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ByteNumberConverter());
        DefaultConverterLoader.putAllConverter(new ByteStringConverter());
        DefaultConverterLoader.putAllConverter(new DateNumberConverter());
        DefaultConverterLoader.putAllConverter(new DateStringConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateNumberConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateStringConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateTimeNumberConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateTimeStringConverter());
        DefaultConverterLoader.putAllConverter(new DoubleBooleanConverter());
        DefaultConverterLoader.putAllConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putAllConverter(new DoubleStringConverter());
        DefaultConverterLoader.putAllConverter(new FloatBooleanConverter());
        DefaultConverterLoader.putAllConverter(new FloatNumberConverter());
        DefaultConverterLoader.putAllConverter(new FloatStringConverter());
        DefaultConverterLoader.putAllConverter(new IntegerBooleanConverter());
        DefaultConverterLoader.putAllConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putAllConverter(new IntegerStringConverter());
        DefaultConverterLoader.putAllConverter(new LongBooleanConverter());
        DefaultConverterLoader.putAllConverter(new LongNumberConverter());
        DefaultConverterLoader.putAllConverter(new LongStringConverter());
        DefaultConverterLoader.putAllConverter(new ShortBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ShortNumberConverter());
        DefaultConverterLoader.putAllConverter(new ShortStringConverter());
        DefaultConverterLoader.putAllConverter(new StringBooleanConverter());
        DefaultConverterLoader.putAllConverter(new StringNumberConverter());
        DefaultConverterLoader.putAllConverter(new StringStringConverter());
        DefaultConverterLoader.putAllConverter(new StringErrorConverter());
    }

    private static void initDefaultWriteConverter() {
        defaultWriteConverter = MapUtils.newHashMapWithExpectedSize(40);
        DefaultConverterLoader.putWriteConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putWriteConverter(new BigIntegerNumberConverter());
        DefaultConverterLoader.putWriteConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putWriteConverter(new ByteNumberConverter());
        DefaultConverterLoader.putWriteConverter(new DateDateConverter());
        DefaultConverterLoader.putWriteConverter(new LocalDateTimeDateConverter());
        DefaultConverterLoader.putWriteConverter(new LocalDateDateConverter());
        DefaultConverterLoader.putWriteConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putWriteConverter(new FloatNumberConverter());
        DefaultConverterLoader.putWriteConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putWriteConverter(new LongNumberConverter());
        DefaultConverterLoader.putWriteConverter(new ShortNumberConverter());
        DefaultConverterLoader.putWriteConverter(new StringStringConverter());
        DefaultConverterLoader.putWriteConverter(new FileImageConverter());
        DefaultConverterLoader.putWriteConverter(new InputStreamImageConverter());
        DefaultConverterLoader.putWriteConverter(new ByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new BoxingByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new UrlImageConverter());
        DefaultConverterLoader.putWriteStringConverter(new BigDecimalStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new BigIntegerStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new BooleanStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new ByteStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new DateStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new LocalDateStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new LocalDateTimeStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new DoubleStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new FloatStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new IntegerStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new LongStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new ShortStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new StringStringConverter());
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadDefaultWriteConverter() {
        return defaultWriteConverter;
    }

    private static void putWriteConverter(Converter<?> converter) {
        defaultWriteConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey()), converter);
    }

    private static void putWriteStringConverter(Converter<?> converter) {
        defaultWriteConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadDefaultReadConverter() {
        return DefaultConverterLoader.loadAllConverter();
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadAllConverter() {
        return allConverter;
    }

    private static void putAllConverter(Converter<?> converter) {
        allConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
    }

    static {
        DefaultConverterLoader.initDefaultWriteConverter();
        DefaultConverterLoader.initAllConverter();
    }
}

