/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.read.builder;

import cn.idev.excel.ExcelReader;
import cn.idev.excel.cache.ReadCache;
import cn.idev.excel.cache.selector.ReadCacheSelector;
import cn.idev.excel.enums.CellExtraTypeEnum;
import cn.idev.excel.enums.ReadDefaultReturnEnum;
import cn.idev.excel.event.SyncReadListener;
import cn.idev.excel.read.builder.AbstractExcelReaderParameterBuilder;
import cn.idev.excel.read.builder.ExcelReaderSheetBuilder;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.support.ExcelTypeEnum;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;

public class ExcelReaderBuilder
extends AbstractExcelReaderParameterBuilder<ExcelReaderBuilder, ReadWorkbook> {
    private final ReadWorkbook readWorkbook = new ReadWorkbook();

    public ExcelReaderBuilder excelType(ExcelTypeEnum excelType) {
        this.readWorkbook.setExcelType(excelType);
        return this;
    }

    public ExcelReaderBuilder file(InputStream inputStream) {
        this.readWorkbook.setInputStream(inputStream);
        return this;
    }

    public ExcelReaderBuilder file(File file) {
        this.readWorkbook.setFile(file);
        return this;
    }

    public ExcelReaderBuilder file(String pathName) {
        return this.file(new File(pathName));
    }

    public ExcelReaderBuilder charset(Charset charset) {
        this.readWorkbook.setCharset(charset);
        return this;
    }

    public ExcelReaderBuilder mandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.readWorkbook.setMandatoryUseInputStream(mandatoryUseInputStream);
        return this;
    }

    public ExcelReaderBuilder autoCloseStream(Boolean autoCloseStream) {
        this.readWorkbook.setAutoCloseStream(autoCloseStream);
        return this;
    }

    public ExcelReaderBuilder ignoreEmptyRow(Boolean ignoreEmptyRow) {
        this.readWorkbook.setIgnoreEmptyRow(ignoreEmptyRow);
        return this;
    }

    public ExcelReaderBuilder customObject(Object customObject) {
        this.readWorkbook.setCustomObject(customObject);
        return this;
    }

    public ExcelReaderBuilder readCache(ReadCache readCache) {
        this.readWorkbook.setReadCache(readCache);
        return this;
    }

    public ExcelReaderBuilder readCacheSelector(ReadCacheSelector readCacheSelector) {
        this.readWorkbook.setReadCacheSelector(readCacheSelector);
        return this;
    }

    public ExcelReaderBuilder password(String password) {
        this.readWorkbook.setPassword(password);
        return this;
    }

    public ExcelReaderBuilder xlsxSAXParserFactoryName(String xlsxSAXParserFactoryName) {
        this.readWorkbook.setXlsxSAXParserFactoryName(xlsxSAXParserFactoryName);
        return this;
    }

    public ExcelReaderBuilder extraRead(CellExtraTypeEnum extraType) {
        if (this.readWorkbook.getExtraReadSet() == null) {
            this.readWorkbook.setExtraReadSet(new HashSet<CellExtraTypeEnum>());
        }
        this.readWorkbook.getExtraReadSet().add(extraType);
        return this;
    }

    public ExcelReaderBuilder useDefaultListener(Boolean useDefaultListener) {
        this.readWorkbook.setUseDefaultListener(useDefaultListener);
        return this;
    }

    public ExcelReaderBuilder readDefaultReturn(ReadDefaultReturnEnum readDefaultReturn) {
        this.readWorkbook.setReadDefaultReturn(readDefaultReturn);
        return this;
    }

    public ExcelReaderBuilder numRows(Integer numRows) {
        this.readWorkbook.setNumRows(numRows);
        return this;
    }

    public ExcelReader build() {
        return new ExcelReader(this.readWorkbook);
    }

    public void doReadAll() {
        try (ExcelReader excelReader = this.build();){
            excelReader.readAll();
        }
    }

    public <T> List<T> doReadAllSync() {
        SyncReadListener syncReadListener = new SyncReadListener();
        this.registerReadListener(syncReadListener);
        try (ExcelReader excelReader = this.build();){
            excelReader.readAll();
            excelReader.finish();
        }
        return syncReadListener.getList();
    }

    public ExcelReaderSheetBuilder sheet() {
        return this.sheet(null, null);
    }

    public ExcelReaderSheetBuilder sheet(Integer sheetNo) {
        return this.sheet(sheetNo, null);
    }

    public ExcelReaderSheetBuilder sheet(String sheetName) {
        return this.sheet(null, sheetName);
    }

    public ExcelReaderSheetBuilder sheet(Integer sheetNo, String sheetName) {
        ExcelReaderSheetBuilder excelReaderSheetBuilder = new ExcelReaderSheetBuilder(this.build());
        if (sheetNo != null) {
            excelReaderSheetBuilder.sheetNo(sheetNo);
        }
        if (sheetName != null) {
            excelReaderSheetBuilder.sheetName(sheetName);
        }
        return excelReaderSheetBuilder;
    }

    @Override
    protected ReadWorkbook parameter() {
        return this.readWorkbook;
    }
}

