/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.builder;

import cn.idev.excel.ExcelWriter;
import cn.idev.excel.exception.ExcelGenerateException;
import cn.idev.excel.write.builder.AbstractExcelWriterParameterBuilder;
import cn.idev.excel.write.builder.ExcelWriterTableBuilder;
import cn.idev.excel.write.metadata.WriteSheet;
import cn.idev.excel.write.metadata.fill.FillConfig;
import java.util.Collection;
import java.util.function.Supplier;

public class ExcelWriterSheetBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterSheetBuilder, WriteSheet> {
    private ExcelWriter excelWriter;
    private final WriteSheet writeSheet = new WriteSheet();

    public ExcelWriterSheetBuilder() {
    }

    public ExcelWriterSheetBuilder(ExcelWriter excelWriter) {
        this.excelWriter = excelWriter;
    }

    public ExcelWriterSheetBuilder sheetNo(Integer sheetNo) {
        this.writeSheet.setSheetNo(sheetNo);
        return this;
    }

    public ExcelWriterSheetBuilder sheetName(String sheetName) {
        this.writeSheet.setSheetName(sheetName);
        return this;
    }

    public WriteSheet build() {
        return this.writeSheet;
    }

    public void doWrite(Collection<?> data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.write(data, this.build());
        this.excelWriter.finish();
    }

    public void doFill(Object data) {
        this.doFill(data, null);
    }

    public void doFill(Object data, FillConfig fillConfig) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'FastExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.fill(data, fillConfig, this.build());
        this.excelWriter.finish();
    }

    public void doWrite(Supplier<Collection<?>> supplier) {
        this.doWrite(supplier.get());
    }

    public void doFill(Supplier<Object> supplier) {
        this.doFill(supplier.get());
    }

    public void doFill(Supplier<Object> supplier, FillConfig fillConfig) {
        this.doFill(supplier.get(), fillConfig);
    }

    public ExcelWriterTableBuilder table() {
        return this.table(null);
    }

    public ExcelWriterTableBuilder table(Integer tableNo) {
        ExcelWriterTableBuilder excelWriterTableBuilder = new ExcelWriterTableBuilder(this.excelWriter, this.build());
        if (tableNo != null) {
            excelWriterTableBuilder.tableNo(tableNo);
        }
        return excelWriterTableBuilder;
    }

    @Override
    protected WriteSheet parameter() {
        return this.writeSheet;
    }
}

