/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.sms;

import cn.javaer.aliyun.sms.BatchSmsTemplate;
import cn.javaer.aliyun.sms.SmsException;
import cn.javaer.aliyun.sms.SmsTemplate;
import cn.javaer.aliyun.sms.Utils;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class SmsClient {
    private final IAcsClient acsClient;
    private final Map<String, SmsTemplate> smsTemplates;
    private final Gson gson = new Gson();

    public SmsClient(String accessKeyId, String accessKeySecret) {
        this(accessKeyId, accessKeySecret, Collections.emptyMap());
    }

    public SmsClient(String accessKeyId, String accessKeySecret, Map<String, SmsTemplate> smsTemplates) {
        Utils.checkNotEmpty(accessKeyId, "'accessKeyId' must be not empty");
        Utils.checkNotEmpty(accessKeySecret, "'accessKeySecret' must be not empty");
        DefaultProfile clientProfile = DefaultProfile.getProfile((String)"default", (String)accessKeyId, (String)accessKeySecret);
        this.acsClient = new DefaultAcsClient((IClientProfile)clientProfile);
        this.smsTemplates = smsTemplates;
    }

    public SmsClient(IAcsClient acsClient, Map<String, SmsTemplate> smsTemplates) {
        this.acsClient = acsClient;
        this.smsTemplates = smsTemplates;
    }

    public int sendVerificationCode(String smsTemplateKey, String phoneNumber) {
        Utils.checkPhoneNumber(phoneNumber);
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        int code = Utils.randomCode();
        smsTemplate.setTemplateParam(Collections.singletonMap("code", String.valueOf(code)));
        smsTemplate.setPhoneNumbers(Collections.singletonList(phoneNumber));
        this.send(smsTemplate);
        return code;
    }

    public void send(String smsTemplateKey) {
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        this.send(smsTemplate);
    }

    public void send(String smsTemplateKey, String ... phoneNumbers) {
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
    }

    public void send(SmsTemplate smsTemplate) {
        Objects.requireNonNull(smsTemplate);
        Utils.checkSmsTemplate(smsTemplate);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("PhoneNumbers", String.join((CharSequence)",", smsTemplate.getPhoneNumbers()));
        request.putQueryParameter("SignName", smsTemplate.getSignName());
        request.putQueryParameter("TemplateCode", smsTemplate.getTemplateCode());
        request.putQueryParameter("TemplateParam", Utils.toJsonStr(smsTemplate.getTemplateParam()));
        try {
            CommonResponse response = this.acsClient.getCommonResponse(request);
            Utils.checkSmsResponse(response);
        }
        catch (ClientException e) {
            throw new SmsException(e);
        }
    }

    public void send(BatchSmsTemplate batchSmsTemplate) {
        Objects.requireNonNull(batchSmsTemplate);
        Utils.checkBatchSmsTemplate(batchSmsTemplate);
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendBatchSms");
        request.putQueryParameter("PhoneNumberJson", this.gson.toJson(batchSmsTemplate.getPhoneNumbers()));
        request.putQueryParameter("SignNameJson", this.gson.toJson(batchSmsTemplate.getSignNames()));
        request.putQueryParameter("TemplateCode", batchSmsTemplate.getTemplateCode());
        request.putQueryParameter("TemplateParamJson", this.gson.toJson(batchSmsTemplate.getTemplateParams()));
        try {
            CommonResponse response = this.acsClient.getCommonResponse(request);
            Utils.checkSmsResponse(response);
        }
        catch (ClientException e) {
            throw new SmsException(e);
        }
    }
}

