/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.push.model.PushModel;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class Options
implements PushModel {
    private static final String SENDNO = "sendno";
    private static final String OVERRIDE_MSG_ID = "override_msg_id";
    private static final String TIME_TO_LIVE = "time_to_live";
    private static final String APNS_PRODUCTION = "apns_production";
    private static final long NONE_TIME_TO_LIVE = -1L;
    private final int sendno;
    private final long overrideMsgId;
    private long timeToLive;
    private boolean apnsProduction;

    private Options(int sendno, long overrideMsgId, long timeToLive, boolean apnsProduction) {
        this.sendno = sendno;
        this.overrideMsgId = overrideMsgId;
        this.timeToLive = timeToLive;
        this.apnsProduction = apnsProduction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Options sendno() {
        return Options.newBuilder().setSendno(ServiceHelper.generateSendno()).build();
    }

    public static Options sendno(int sendno) {
        return Options.newBuilder().setSendno(sendno).build();
    }

    public void setApnsProduction(boolean apnsProduction) {
        this.apnsProduction = apnsProduction;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getSendno() {
        return this.sendno;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (this.sendno > 0) {
            json.add(SENDNO, (JsonElement)new JsonPrimitive((Number)this.sendno));
        }
        if (this.overrideMsgId > 0L) {
            json.add(OVERRIDE_MSG_ID, (JsonElement)new JsonPrimitive((Number)this.overrideMsgId));
        }
        if (this.timeToLive >= 0L) {
            json.add(TIME_TO_LIVE, (JsonElement)new JsonPrimitive((Number)this.timeToLive));
        }
        json.add(APNS_PRODUCTION, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.apnsProduction)));
        return json;
    }

    public static class Builder {
        private int sendno = 0;
        private long overrideMsgId = 0L;
        private long timeToLive = -1L;
        private boolean apnsProduction = false;

        public Builder setSendno(int sendno) {
            this.sendno = sendno;
            return this;
        }

        public Builder setOverrideMsgId(long overrideMsgId) {
            this.overrideMsgId = overrideMsgId;
            return this;
        }

        public Builder setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder setApnsProduction(boolean apnsProduction) {
            this.apnsProduction = apnsProduction;
            return this;
        }

        public Options build() {
            Preconditions.checkArgument((this.sendno >= 0 ? 1 : 0) != 0, (Object)"sendno should be greater than 0.");
            Preconditions.checkArgument((this.overrideMsgId >= 0L ? 1 : 0) != 0, (Object)"override_msg_id should be greater than 0.");
            Preconditions.checkArgument((this.timeToLive >= -1L ? 1 : 0) != 0, (Object)"time_to_live should be greater than 0.");
            if (this.sendno <= 0) {
                this.sendno = ServiceHelper.generateSendno();
            }
            return new Options(this.sendno, this.overrideMsgId, this.timeToLive, this.apnsProduction);
        }
    }
}

