/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class WinphoneNotification
extends PlatformNotification {
    private static final String NOTIFICATION_WINPHONE = "winphone";
    private static final String TITLE = "title";
    private static final String _OPEN_PAGE = "_open_page";
    private final String title;
    private final String openPage;

    private WinphoneNotification(String alert, String title, String openPage, ImmutableMap<String, String> extras, ImmutableMap<String, Number> numberExtras, ImmutableMap<String, Boolean> booleanExtras) {
        super(alert, extras, numberExtras, booleanExtras);
        this.title = title;
        this.openPage = openPage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static WinphoneNotification alert(String alert) {
        return WinphoneNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_WINPHONE;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (null != this.openPage) {
            json.add(_OPEN_PAGE, (JsonElement)new JsonPrimitive(this.openPage));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<WinphoneNotification> {
        private String title;
        private String openPage;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setOpenPage(String openPage) {
            this.openPage = openPage;
            return this;
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            this.extrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            if (null == extras) {
                PlatformNotification.LOG.warn("Null extras param. Throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = ImmutableMap.builder();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put((Object)key, (Object)extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = ImmutableMap.builder();
            }
            this.numberExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key ? 1 : 0) != 0, (Object)"Key should not be null.");
            if (null == value) {
                PlatformNotification.LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = ImmutableMap.builder();
            }
            this.booleanExtrasBuilder.put((Object)key, (Object)value);
            return this;
        }

        @Override
        public WinphoneNotification build() {
            return new WinphoneNotification(this.alert, this.title, this.openPage, null == this.extrasBuilder ? null : this.extrasBuilder.build(), null == this.numberExtrasBuilder ? null : this.numberExtrasBuilder.build(), null == this.booleanExtrasBuilder ? null : this.booleanExtrasBuilder.build());
        }
    }
}

