/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.device;

import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.common.connection.HttpProxy;
import cn.jpush.api.common.connection.NativeHttpClient;
import cn.jpush.api.common.resp.APIConnectionException;
import cn.jpush.api.common.resp.APIRequestException;
import cn.jpush.api.common.resp.BaseResult;
import cn.jpush.api.common.resp.BooleanResult;
import cn.jpush.api.common.resp.DefaultResult;
import cn.jpush.api.common.resp.ResponseWrapper;
import cn.jpush.api.device.AliasDeviceListResult;
import cn.jpush.api.device.TagAliasResult;
import cn.jpush.api.device.TagListResult;
import cn.jpush.api.utils.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Set;

public class DeviceClient {
    public static final String HOST_NAME_SSL = "https://device.jpush.cn";
    public static final String DEVICES_PATH = "/v3/devices";
    public static final String TAGS_PATH = "/v3/tags";
    public static final String ALIASES_PATH = "/v3/aliases";
    private final NativeHttpClient _httpClient;

    public DeviceClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, 3);
    }

    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    public DeviceClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._httpClient = new NativeHttpClient(authCode, maxRetryTimes, proxy);
    }

    public TagAliasResult getDeviceTagAlias(String registrationId) throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, TagAliasResult.class);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, boolean clearAlias, boolean clearTag) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument(clearAlias || clearTag, "It is not meaningful to do nothing.");
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        JsonObject top = new JsonObject();
        if (clearAlias) {
            top.addProperty("alias", "");
        }
        if (clearTag) {
            top.addProperty("tags", "");
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public DefaultResult updateDeviceTagAlias(String registrationId, String alias, Set<String> tagsToAdd, Set<String> tagsToRemove) throws APIConnectionException, APIRequestException {
        JsonArray tagsRemove;
        String url = "https://device.jpush.cn/v3/devices/" + registrationId;
        JsonObject top = new JsonObject();
        if (null != alias) {
            top.addProperty("alias", alias);
        }
        JsonObject tagObject = new JsonObject();
        JsonArray tagsAdd = ServiceHelper.fromSet(tagsToAdd);
        if (tagsAdd.size() > 0) {
            tagObject.add("add", (JsonElement)tagsAdd);
        }
        if ((tagsRemove = ServiceHelper.fromSet(tagsToRemove)).size() > 0) {
            tagObject.add("remove", (JsonElement)tagsRemove);
        }
        if (tagObject.entrySet().size() > 0) {
            top.add("tags", (JsonElement)tagObject);
        }
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public TagListResult getTagList() throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/tags/";
        ResponseWrapper response = this._httpClient.sendGet(url);
        return TagListResult.fromResponse(response, TagListResult.class);
    }

    public BooleanResult isDeviceInTag(String theTag, String registrationID) throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/tags/" + theTag + "/registration_ids/" + registrationID;
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, BooleanResult.class);
    }

    public DefaultResult addRemoveDevicesFromTag(String theTag, Set<String> toAddUsers, Set<String> toRemoveUsers) throws APIConnectionException, APIRequestException {
        JsonArray array;
        String url = "https://device.jpush.cn/v3/tags/" + theTag;
        JsonObject top = new JsonObject();
        JsonObject registrationIds = new JsonObject();
        if (null != toAddUsers && toAddUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toAddUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("add", (JsonElement)array);
        }
        if (null != toRemoveUsers && toRemoveUsers.size() > 0) {
            array = new JsonArray();
            for (String user : toRemoveUsers) {
                array.add((JsonElement)new JsonPrimitive(user));
            }
            registrationIds.add("remove", (JsonElement)array);
        }
        top.add("registration_ids", (JsonElement)registrationIds);
        ResponseWrapper response = this._httpClient.sendPost(url, top.toString());
        return DefaultResult.fromResponse(response);
    }

    public DefaultResult deleteTag(String theTag, String platform) throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/tags/" + theTag;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse(response);
    }

    public AliasDeviceListResult getAliasDeviceList(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/aliases/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendGet(url);
        return BaseResult.fromResponse(response, AliasDeviceListResult.class);
    }

    public DefaultResult deleteAlias(String alias, String platform) throws APIConnectionException, APIRequestException {
        String url = "https://device.jpush.cn/v3/aliases/" + alias;
        if (null != platform) {
            url = url + "?platform=" + platform;
        }
        ResponseWrapper response = this._httpClient.sendDelete(url);
        return DefaultResult.fromResponse(response);
    }
}

