/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.utils.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlatformNotification
implements PushModel {
    public static final String ALERT = "alert";
    private static final String EXTRAS = "extras";
    protected static final Logger LOG = LoggerFactory.getLogger(PlatformNotification.class);
    private String alert;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;

    public PlatformNotification(String alert, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        this.alert = alert;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
    }

    @Override
    public JsonElement toJSON() {
        Object value;
        JsonObject json = new JsonObject();
        if (null != this.alert) {
            json.add(ALERT, (JsonElement)new JsonPrimitive(this.alert));
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            value = null;
            for (String key : this.extras.keySet()) {
                value = this.extras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((String)value));
            }
        }
        if (null != this.numberExtras) {
            value = null;
            for (String key : this.numberExtras.keySet()) {
                value = this.numberExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Number)value));
            }
        }
        if (null != this.booleanExtras) {
            value = null;
            for (String key : this.booleanExtras.keySet()) {
                value = this.booleanExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Boolean)value));
            }
        }
        if (null != this.jsonExtras) {
            value = null;
            for (String key : this.jsonExtras.keySet()) {
                value = this.jsonExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)value);
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    protected String getAlert() {
        return this.alert;
    }

    protected void setAlert(String alert) {
        this.alert = alert;
    }

    protected abstract String getPlatform();

    protected static abstract class Builder<T> {
        protected String alert;
        protected Map<String, String> extrasBuilder;
        protected Map<String, Number> numberExtrasBuilder;
        protected Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;

        protected Builder() {
        }

        public abstract Builder<T> setAlert(String var1);

        public Builder<T> addExtra(String key, String value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder<T> addExtras(Map<String, String> extras) {
            if (null == extras) {
                LOG.warn("Null extras param. Throw away it.");
                return this;
            }
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder<T> addExtra(String key, Number value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder<T> addExtra(String key, Boolean value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder<T> addExtra(String key, JsonObject value) {
            Preconditions.checkArgument(null != key, "Key should not be null.");
            if (null == value) {
                LOG.debug("Extra value is null, throw away it.");
                return this;
            }
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public abstract T build();
    }
}

